/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.jei.display;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.recipe.RecipeType;
import net.mehvahdjukaar.jeed.common.Constants;
import net.mehvahdjukaar.jeed.common.EffectInfo;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class EffectInfoRecipe
extends EffectInfo {
    public static final RecipeType<EffectInfoRecipe> TYPE = RecipeType.create((String)"jeed", (String)"effect_info", EffectInfoRecipe.class);
    protected final List<class_1856> ingredients;
    protected final List<class_1856> slots;

    protected EffectInfoRecipe(class_1293 effectInstance, List<class_1856> ingredients, List<class_5348> description) {
        super(effectInstance, description);
        this.ingredients = ingredients;
        this.slots = EffectInfoRecipe.divideIntoSlots(ingredients, EffectInfo::mergeIngredients);
    }

    public static List<EffectInfoRecipe> create(class_6880<class_1291> effect) {
        class_310 minecraft = class_310.method_1551();
        class_2561 text = EffectInfoRecipe.getDescription(effect);
        List<class_1856> inputs = EffectInfoRecipe.groupIngredients(EffectInfoRecipe.computeItemProviders((class_1291)effect.comp_349()));
        int listH = EffectInfoRecipe.getListHeight(inputs);
        ArrayList<EffectInfoRecipe> recipes = new ArrayList<EffectInfoRecipe>();
        List<class_5348> descriptionLines = EffectInfoRecipe.expandNewlines(text);
        descriptionLines = EffectInfoRecipe.wrapDescriptionLines(descriptionLines);
        int lineCount = descriptionLines.size();
        Objects.requireNonNull(minecraft.field_1772);
        int maxLinesPerPage = (Constants.RECIPE_HEIGHT - 35 - listH) / (9 + Constants.LINE_SPACING);
        int pageCount = EffectInfoRecipe.divideCeil(lineCount, maxLinesPerPage);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * maxLinesPerPage;
            int endLine = Math.min((i + 1) * maxLinesPerPage, lineCount);
            List<class_5348> description = descriptionLines.subList(startLine, endLine);
            EffectInfoRecipe recipe = new EffectInfoRecipe(new class_1293(effect), inputs, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private static int divideCeil(int numerator, int denominator) {
        return (int)Math.ceil((float)numerator / (float)denominator);
    }

    private static List<class_5348> expandNewlines(class_2561 descriptionComponents) {
        ArrayList<class_5348> descriptionLinesExpanded = new ArrayList<class_5348>();
        ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
        descriptionComponents.method_27658((class_5348.class_5246)newLineTextAcceptor, class_2583.field_24360);
        newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
        return descriptionLinesExpanded;
    }

    private static List<class_5348> wrapDescriptionLines(List<class_5348> descriptionLines) {
        class_310 minecraft = class_310.method_1551();
        ArrayList<class_5348> descriptionLinesWrapped = new ArrayList<class_5348>();
        for (class_5348 descriptionLine : descriptionLines) {
            List textLines = minecraft.field_1772.method_27527().method_27495(descriptionLine, Constants.RECIPE_WIDTH, class_2583.field_24360);
            descriptionLinesWrapped.addAll(textLines);
        }
        return descriptionLinesWrapped;
    }

    private static class ExpandNewLineTextAcceptor
    implements class_5348.class_5246<Void> {
        private final List<class_5348> lines = new ArrayList<class_5348>();
        @Nullable
        private class_5250 lastComponent;

        private ExpandNewLineTextAcceptor() {
        }

        public Optional<Void> accept(class_2583 style, String line) {
            String[] descriptionLineExpanded = line.split("\\\\n");
            for (int i = 0; i < descriptionLineExpanded.length; ++i) {
                String s = descriptionLineExpanded[i];
                if (s.isEmpty()) {
                    if (i == 0 && this.lastComponent != null) {
                        this.lines.add((class_5348)this.lastComponent);
                        this.lastComponent = null;
                        continue;
                    }
                    this.lines.add(class_2561.field_25310);
                    continue;
                }
                class_5250 textComponent = class_2561.method_43470((String)s);
                textComponent.method_10862(style);
                if (this.lastComponent != null) {
                    if (i == 0) {
                        if (!this.lastComponent.method_10866().method_10967() && !this.lastComponent.method_10866().equals((Object)style)) {
                            this.lastComponent = class_2561.method_43470((String)"").method_10852((class_2561)this.lastComponent);
                        }
                        this.lastComponent.method_10852((class_2561)textComponent);
                        continue;
                    }
                    this.lines.add((class_5348)this.lastComponent);
                    this.lastComponent = null;
                }
                if (i == descriptionLineExpanded.length - 1) {
                    this.lastComponent = textComponent;
                    continue;
                }
                this.lines.add((class_5348)textComponent);
            }
            return Optional.empty();
        }

        public void addLinesTo(List<class_5348> descriptionLinesExpanded) {
            descriptionLinesExpanded.addAll(this.lines);
            if (this.lastComponent != null) {
                descriptionLinesExpanded.add((class_5348)this.lastComponent);
            }
        }
    }
}

