/*
 * Decompiled with CFR 0.152.
 */
package io.shantek;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4081;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class EffectMonitor
implements ClientModInitializer {
    private DisplayMode currentMode = DisplayMode.ACTIONBAR;
    private EffectFilter effectFilter = EffectFilter.ALL;
    private boolean soundEnabled = true;
    private boolean notificationsEnabled = true;
    private final Map<UUID, Map<String, Set<Integer>>> alerted = new HashMap<UUID, Map<String, Set<Integer>>>();
    private final List<Integer> thresholds = new ArrayList<Integer>(List.of(Integer.valueOf(60), Integer.valueOf(30), Integer.valueOf(5)));
    private class_304 openConfigKey;
    private class_304 toggleNotificationsKey;
    private final File configFile = new File("config/effectmonitor.properties");

    public void onInitializeClient() {
        this.loadSettings();
        this.openConfigKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.effectmonitor.config", class_3675.class_307.field_1668, -1, class_304.class_11900.field_62556));
        this.toggleNotificationsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.effectmonitor.toggle", class_3675.class_307.field_1668, -1, class_304.class_11900.field_62556));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (this.openConfigKey.method_1436()) {
                client.method_1507((class_437)new ConfigScreen());
            }
            while (this.toggleNotificationsKey.method_1436()) {
                this.notificationsEnabled = !this.notificationsEnabled;
                this.saveSettings();
                if (client.field_1724 == null) continue;
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Effect Monitor: " + (this.notificationsEnabled ? "Enabled" : "Disabled"))), true);
            }
            if (client.field_1724 == null) {
                return;
            }
            class_746 player = client.field_1724;
            UUID uuid = player.method_5667();
            Map playerAlerts = this.alerted.computeIfAbsent(uuid, k -> new HashMap());
            for (class_1293 effect : player.method_6026()) {
                String effectName;
                Set alertedThresholds;
                int previousLowest;
                class_1291 effectType = (class_1291)effect.method_5579().comp_349();
                class_4081 category = effectType.method_18792();
                if (this.effectFilter == EffectFilter.POSITIVE && category != class_4081.field_18271 || this.effectFilter == EffectFilter.NEGATIVE && category != class_4081.field_18272) continue;
                int secondsLeft = effect.method_5584() / 20;
                if (secondsLeft > (previousLowest = (alertedThresholds = playerAlerts.computeIfAbsent(effectName = effectType.method_5567().replace("effect.minecraft.", ""), k -> new HashSet())).stream().min(Integer::compare).orElse(Integer.MAX_VALUE).intValue())) {
                    alertedThresholds.clear();
                }
                for (int threshold : this.thresholds) {
                    String timeText;
                    String formattedName;
                    if (secondsLeft < threshold) {
                        alertedThresholds.add(threshold);
                        continue;
                    }
                    if (alertedThresholds.contains(threshold) || secondsLeft != threshold) continue;
                    alertedThresholds.add(threshold);
                    if (!this.notificationsEnabled) continue;
                    String string = formattedName = effectName.isEmpty() ? "Unknown" : Arrays.stream(effectName.replace("_", " ").split(" ")).filter(w -> !w.isEmpty()).map(w -> Character.toUpperCase(w.charAt(0)) + w.substring(1)).collect(Collectors.joining(" "));
                    String string2 = secondsLeft >= 60 ? secondsLeft / 60 + "m" + (String)(secondsLeft % 60 > 0 ? " " + secondsLeft % 60 + "s" : "") : (timeText = secondsLeft + "s");
                    if (this.currentMode == DisplayMode.TITLE) {
                        client.field_1705.method_34004((class_2561)class_2561.method_43470((String)"\u23f3 Effect Fading"));
                        client.field_1705.method_34002((class_2561)class_2561.method_43470((String)(formattedName + " ends in " + timeText)));
                        client.field_1705.method_34001(10, 40, 10);
                    } else {
                        player.method_7353((class_2561)class_2561.method_43470((String)("\u23f3 " + formattedName + " ends in " + timeText)), true);
                    }
                    if (!this.soundEnabled) continue;
                    player.method_5783((class_3414)class_3417.field_15047.comp_349(), 4.0f, 1.0f);
                }
            }
            playerAlerts.entrySet().removeIf(entry -> player.method_6026().stream().noneMatch(effect -> ((class_1291)effect.method_5579().comp_349()).method_5567().replace("effect.minecraft.", "").equals(entry.getKey())));
        });
    }

    private void loadSettings() {
        if (this.configFile.exists()) {
            try (FileReader reader = new FileReader(this.configFile);){
                Properties props = new Properties();
                props.load(reader);
                this.currentMode = DisplayMode.valueOf(props.getProperty("mode", "ACTIONBAR"));
                this.soundEnabled = Boolean.parseBoolean(props.getProperty("sound", "true"));
                this.notificationsEnabled = Boolean.parseBoolean(props.getProperty("enabled", "true"));
                this.effectFilter = EffectFilter.valueOf(props.getProperty("effectFilter", "ALL"));
                String thresholdStr = props.getProperty("thresholds", "60,30,5");
                this.thresholds.clear();
                for (String s : thresholdStr.split(",")) {
                    try {
                        int val = Integer.parseInt(s.trim());
                        if (this.thresholds.contains(val)) continue;
                        this.thresholds.add(val);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                Collections.sort(this.thresholds);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void saveSettings() {
        try {
            this.configFile.getParentFile().mkdirs();
            Properties props = new Properties();
            props.setProperty("mode", this.currentMode.name());
            props.setProperty("sound", Boolean.toString(this.soundEnabled));
            props.setProperty("enabled", Boolean.toString(this.notificationsEnabled));
            props.setProperty("effectFilter", this.effectFilter.name());
            props.setProperty("thresholds", this.thresholds.stream().map(Object::toString).collect(Collectors.joining(",")));
            props.store(new FileWriter(this.configFile), "Effect Monitor Config");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Environment(value=EnvType.CLIENT)
    static enum DisplayMode {
        TITLE,
        ACTIONBAR;

    }

    @Environment(value=EnvType.CLIENT)
    static enum EffectFilter {
        ALL,
        POSITIVE,
        NEGATIVE;

    }

    @Environment(value=EnvType.CLIENT)
    private class ConfigScreen
    extends class_437 {
        protected ConfigScreen() {
            super((class_2561)class_2561.method_43470((String)"Effect Monitor Config"));
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_25394(context, mouseX, mouseY, delta);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"\u00a7lEffect Monitor"), this.field_22789 / 2, 15, 0xFFFFFF);
        }

        protected void method_25426() {
            int centerX = this.field_22789 / 2;
            int topY = 35;
            int buttonHeight = 20;
            int lineSpacing = 25;
            int sectionY = topY;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Mode: " + String.valueOf((Object)EffectMonitor.this.currentMode))), button -> {
                EffectMonitor.this.currentMode = EffectMonitor.this.currentMode == DisplayMode.TITLE ? DisplayMode.ACTIONBAR : DisplayMode.TITLE;
                EffectMonitor.this.saveSettings();
                button.method_25355((class_2561)class_2561.method_43470((String)("Mode: " + String.valueOf((Object)EffectMonitor.this.currentMode))));
            }).method_46434(centerX - 100, sectionY, 200, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Sound: " + (EffectMonitor.this.soundEnabled ? "On" : "Off"))), button -> {
                EffectMonitor.this.soundEnabled = !EffectMonitor.this.soundEnabled;
                EffectMonitor.this.saveSettings();
                button.method_25355((class_2561)class_2561.method_43470((String)("Sound: " + (EffectMonitor.this.soundEnabled ? "On" : "Off"))));
            }).method_46434(centerX - 100, sectionY += lineSpacing, 200, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Notifications: " + (EffectMonitor.this.notificationsEnabled ? "Enabled" : "Disabled"))), button -> {
                EffectMonitor.this.notificationsEnabled = !EffectMonitor.this.notificationsEnabled;
                EffectMonitor.this.saveSettings();
                button.method_25355((class_2561)class_2561.method_43470((String)("Notifications: " + (EffectMonitor.this.notificationsEnabled ? "Enabled" : "Disabled"))));
            }).method_46434(centerX - 100, sectionY += lineSpacing, 200, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Effects Shown: " + this.formatEffectFilter(EffectMonitor.this.effectFilter))), button -> {
                switch (EffectMonitor.this.effectFilter.ordinal()) {
                    case 0: {
                        EffectMonitor.this.effectFilter = EffectFilter.POSITIVE;
                        break;
                    }
                    case 1: {
                        EffectMonitor.this.effectFilter = EffectFilter.NEGATIVE;
                        break;
                    }
                    case 2: {
                        EffectMonitor.this.effectFilter = EffectFilter.ALL;
                    }
                }
                EffectMonitor.this.saveSettings();
                button.method_25355((class_2561)class_2561.method_43470((String)("Effects Shown: " + this.formatEffectFilter(EffectMonitor.this.effectFilter))));
            }).method_46434(centerX - 100, sectionY += lineSpacing, 200, buttonHeight).method_46431());
            sectionY += lineSpacing + 10;
            for (int i = 0; i < EffectMonitor.this.thresholds.size(); ++i) {
                int index = i;
                int threshold = EffectMonitor.this.thresholds.get(index);
                int posY = sectionY + i * lineSpacing;
                String formatted = threshold >= 60 ? threshold / 60 + "m" + (String)(threshold % 60 > 0 ? " " + threshold % 60 + "s" : "") : threshold + "s";
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), b -> {
                    int newVal = threshold - 5;
                    if (newVal >= 5 && !EffectMonitor.this.thresholds.contains(newVal)) {
                        EffectMonitor.this.thresholds.set(index, newVal);
                        EffectMonitor.this.thresholds.sort(Collections.reverseOrder());
                        EffectMonitor.this.saveSettings();
                        class_310.method_1551().method_1507((class_437)new ConfigScreen());
                    }
                }).method_46434(centerX - 70, posY, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Decrease by 5s"))).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)formatted), b -> {}).method_46434(centerX - 45, posY, 90, 20).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), b -> {
                    int newVal = threshold + 5;
                    if (newVal <= 240 && !EffectMonitor.this.thresholds.contains(newVal)) {
                        EffectMonitor.this.thresholds.set(index, newVal);
                        EffectMonitor.this.thresholds.sort(Collections.reverseOrder());
                        EffectMonitor.this.saveSettings();
                        class_310.method_1551().method_1507((class_437)new ConfigScreen());
                    }
                }).method_46434(centerX + 50, posY, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Increase by 5s"))).method_46431());
                if (EffectMonitor.this.thresholds.size() <= 1) continue;
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2715"), b -> {
                    EffectMonitor.this.thresholds.remove(index);
                    EffectMonitor.this.thresholds.sort(Collections.reverseOrder());
                    EffectMonitor.this.saveSettings();
                    class_310.method_1551().method_1507((class_437)new ConfigScreen());
                }).method_46434(centerX + 75, posY, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Remove this threshold"))).method_46431());
            }
            if (EffectMonitor.this.thresholds.size() < 3) {
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+ Add Threshold"), b -> {
                    int candidate = 5;
                    while (EffectMonitor.this.thresholds.contains(candidate)) {
                        candidate += 5;
                    }
                    if (candidate <= 240) {
                        EffectMonitor.this.thresholds.add(candidate);
                        EffectMonitor.this.thresholds.sort(Collections.reverseOrder());
                        EffectMonitor.this.saveSettings();
                        class_310.method_1551().method_1507((class_437)new ConfigScreen());
                    }
                }).method_46434(centerX - 100, sectionY + EffectMonitor.this.thresholds.size() * lineSpacing, 200, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Add a new threshold (max 3)"))).method_46431());
            }
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), button -> this.method_25419()).method_46434(centerX - 100, sectionY + EffectMonitor.this.thresholds.size() * lineSpacing + 30, 200, 20).method_46431());
        }

        private String formatEffectFilter(EffectFilter filter) {
            String name = filter.name().toLowerCase();
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }

        public boolean method_25421() {
            return false;
        }
    }
}

