/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.eureka.ship;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4d;
import org.joml.Matrix3dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerTickListener;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.eureka.EurekaConfig;
import org.valkyrienskies.eureka.ship.StabilizeKt;
import org.valkyrienskies.mod.api.SeatedControllingPlayer;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0007\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 v2\u00020\u00012\u00020\u0002:\u0002vwB\u0007\u00a2\u0006\u0004\bu\u0010\u000eJ\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0018\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001d\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u000eJ\u000f\u0010 \u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b \u0010\u000eJ'\u0010!\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b!\u0010$J\u001f\u0010%\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010'\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b'\u0010&R\"\u0010)\u001a\u00020(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0014\u00100\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010,R*\u00103\u001a\u0002012\u0006\u00102\u001a\u0002018\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\"\u00109\u001a\u0002018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u00104\u001a\u0004\b:\u00106\"\u0004\b;\u00108R\u0016\u0010<\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010=R*\u0010>\u001a\u0002012\u0006\u00102\u001a\u0002018\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u00104\u001a\u0004\b?\u00106\"\u0004\b@\u00108R\u0011\u0010B\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010,R$\u0010E\u001a\u00020C2\u0006\u0010D\u001a\u00020C8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bE\u0010F\u001a\u0004\bG\u0010HR\u0018\u0010I\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bI\u0010JR\"\u0010K\u001a\u00020(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010*\u001a\u0004\bL\u0010,\"\u0004\bM\u0010.R\u0016\u0010N\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010=R\u0016\u0010O\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u0010=R*\u0010P\u001a\u0002012\u0006\u00102\u001a\u0002018\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bP\u00104\u001a\u0004\bQ\u00106\"\u0004\bR\u00108R*\u0010S\u001a\u0002012\u0006\u00102\u001a\u0002018\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bS\u00104\u001a\u0004\bT\u00106\"\u0004\bU\u00108R\"\u0010V\u001a\u00020(8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bV\u0010*\u001a\u0004\bV\u0010,\"\u0004\bW\u0010.R\"\u0010X\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bX\u0010=\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R\u0016\u0010]\u001a\u00020C8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b]\u0010FR\u0016\u0010^\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b^\u0010_R\"\u0010`\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b`\u0010=\u001a\u0004\ba\u0010Z\"\u0004\bb\u0010\\R\"\u0010c\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bc\u0010=\u001a\u0004\bd\u0010Z\"\u0004\be\u0010\\R$\u0010g\u001a\u0004\u0018\u00010f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bg\u0010h\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR$\u0010n\u001a\u0004\u0018\u00010m8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0012\n\u0004\bn\u0010o\u001a\u0004\bp\u0010q\"\u0004\br\u0010sR\u0016\u0010t\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bt\u0010*\u00a8\u0006x"}, d2={"Lorg/valkyrienskies/eureka/ship/EurekaShipControl;", "Lorg/valkyrienskies/core/api/ships/ShipForcesInducer;", "Lorg/valkyrienskies/core/api/ships/ServerTickListener;", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physShip", "", "applyForces", "(Lorg/valkyrienskies/core/api/ships/PhysShip;)V", "Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "control", "Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;", "applyPlayerControl", "(Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;)V", "deleteIfEmpty", "()V", "Lorg/valkyrienskies/mod/api/SeatedControllingPlayer;", "player", "getControlData", "(Lorg/valkyrienskies/mod/api/SeatedControllingPlayer;)Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "Lorg/joml/Matrix3dc;", "moiTensor", "", "strength", "Lorg/joml/Vector3d;", "getPlayerControlledBanking", "(Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;Lorg/valkyrienskies/core/api/ships/PhysShip;Lorg/joml/Matrix3dc;D)Lorg/joml/Vector3d;", "getPlayerForwardVel", "(Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;)Lorg/joml/Vector3d;", "mass", "getPlayerUpwardVel", "(Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;D)Lorg/joml/Vector3d;", "onServerTick", "showCruiseStatus", "smoothing", "max", "x", "(DDD)D", "smoothingATan", "(DD)D", "smoothingATanMax", "", "aligning", "Z", "getAligning", "()Z", "setAligning", "(Z)V", "getAnchored", "anchored", "", "v", "anchors", "I", "getAnchors", "()I", "setAnchors", "(I)V", "anchorsActive", "getAnchorsActive", "setAnchorsActive", "angleUntilAligned", "D", "balloons", "getBalloons", "setBalloons", "getCanDisassemble", "canDisassemble", "", "<set-?>", "consumed", "F", "getConsumed", "()F", "controlData", "Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "disassembling", "getDisassembling", "setDisassembling", "extraForceAngular", "extraForceLinear", "floaters", "getFloaters", "setFloaters", "helms", "getHelms", "setHelms", "isCruising", "setCruising", "oldSpeed", "getOldSpeed", "()D", "setOldSpeed", "(D)V", "physConsumption", "positionUntilAligned", "Lorg/joml/Vector3d;", "powerAngular", "getPowerAngular", "setPowerAngular", "powerLinear", "getPowerLinear", "setPowerLinear", "Lnet/minecraft/class_1657;", "seatedPlayer", "Lnet/minecraft/class_1657;", "getSeatedPlayer", "()Lnet/minecraft/class_1657;", "setSeatedPlayer", "(Lnet/minecraft/class_1657;)V", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "getShip$eureka", "()Lorg/valkyrienskies/core/api/ships/ServerShip;", "setShip$eureka", "(Lorg/valkyrienskies/core/api/ships/ServerShip;)V", "wasCruisePressed", "<init>", "Companion", "ControlData", "eureka"})
@SourceDebugExtension(value={"SMAP\nEurekaShipControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EurekaShipControl.kt\norg/valkyrienskies/eureka/ship/EurekaShipControl\n+ 2 ServerShip.kt\norg/valkyrienskies/core/api/ships/ServerShipKt\n*L\n1#1,431:1\n41#2:432\n*S KotlinDebug\n*F\n+ 1 EurekaShipControl.kt\norg/valkyrienskies/eureka/ship/EurekaShipControl\n*L\n390#1:432\n*E\n"})
public final class EurekaShipControl
implements ShipForcesInducer,
ServerTickListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JsonIgnore
    @Nullable
    private ServerShip ship;
    private double extraForceLinear;
    private double extraForceAngular;
    private boolean aligning;
    private boolean disassembling;
    private float physConsumption;
    private double angleUntilAligned;
    @NotNull
    private Vector3d positionUntilAligned = new Vector3d();
    private float consumed;
    private boolean wasCruisePressed;
    @JsonProperty(value="cruise")
    private boolean isCruising;
    @Nullable
    private ControlData controlData;
    @JsonIgnore
    @Nullable
    private class_1657 seatedPlayer;
    @JsonIgnore
    private double oldSpeed;
    private double powerLinear;
    private double powerAngular;
    private int anchors;
    private int anchorsActive;
    private int balloons;
    private int helms;
    private int floaters;
    private static final double ALIGN_THRESHOLD = 0.01;
    private static final double DISASSEMBLE_THRESHOLD = 0.02;
    private static final double GRAVITY = -10.0;

    @Nullable
    public final ServerShip getShip$eureka() {
        return this.ship;
    }

    public final void setShip$eureka(@Nullable ServerShip serverShip) {
        this.ship = serverShip;
    }

    public final boolean getAligning() {
        return this.aligning;
    }

    public final void setAligning(boolean bl) {
        this.aligning = bl;
    }

    public final boolean getDisassembling() {
        return this.disassembling;
    }

    public final void setDisassembling(boolean bl) {
        this.disassembling = bl;
    }

    private final boolean getAnchored() {
        return this.anchorsActive > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getCanDisassemble() {
        if (this.ship == null) return false;
        if (!this.disassembling) return false;
        if (!(Math.abs(this.angleUntilAligned) < 0.02)) return false;
        ServerShip serverShip = this.ship;
        Intrinsics.checkNotNull((Object)serverShip);
        if (!(this.positionUntilAligned.distanceSquared(serverShip.getTransform().getPositionInWorld()) < 4.0)) return false;
        return true;
    }

    public final float getConsumed() {
        return this.consumed;
    }

    public final boolean isCruising() {
        return this.isCruising;
    }

    public final void setCruising(boolean bl) {
        this.isCruising = bl;
    }

    @Nullable
    public final class_1657 getSeatedPlayer() {
        return this.seatedPlayer;
    }

    public final void setSeatedPlayer(@Nullable class_1657 class_16572) {
        this.seatedPlayer = class_16572;
    }

    public final double getOldSpeed() {
        return this.oldSpeed;
    }

    public final void setOldSpeed(double d) {
        this.oldSpeed = d;
    }

    public void applyForces(@NotNull PhysShip physShip) {
        SeatedControllingPlayer controllingPlayer;
        boolean validPlayer;
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        if (this.helms < 1) {
            physShip.setDoFluidDrag(true);
            return;
        }
        physShip.setDoFluidDrag(EurekaConfig.SERVER.getDoFluidDrag());
        PhysShipImpl cfr_ignored_0 = (PhysShipImpl)physShip;
        ServerShip serverShip = this.ship;
        if (serverShip == null) {
            return;
        }
        ServerShip ship = serverShip;
        double mass = ((PhysShipImpl)physShip).getInertia().getShipMass();
        Matrix3dc moiTensor = ((PhysShipImpl)physShip).getInertia().getMomentOfInertiaTensor();
        Vector3dc omega = ((PhysShipImpl)physShip).getPoseVel().getOmega();
        Vector3dc vel = ((PhysShipImpl)physShip).getPoseVel().getVel();
        double balloonForceProvided = (double)this.balloons * EurekaShipControl.Companion.getForcePerBalloon();
        double buoyantFactorPerFloater = Math.min(EurekaConfig.SERVER.getFloaterBuoyantFactorPerKg() / 15.0 / mass, EurekaConfig.SERVER.getMaxFloaterBuoyantFactor());
        physShip.setBuoyantFactor(1.0 + (double)this.floaters * buoyantFactorPerFloater);
        Quaterniond invRotation = ((PhysShipImpl)physShip).getTransform().getShipToWorldRotation().invert(new Quaterniond());
        AxisAngle4d invRotationAxisAngle = new AxisAngle4d((Quaterniondc)invRotation);
        int alignTarget = (int)Math.floor(invRotationAxisAngle.angle / 1.5707963267948966 + 4.5) % 4;
        this.angleUntilAligned = (double)alignTarget * 1.5707963267948966 - invRotationAxisAngle.angle;
        if (this.disassembling) {
            Vector3dc pos = ship.getTransform().getPositionInWorld();
            Vector3d vector3d = pos.floor(new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"floor(...)");
            this.positionUntilAligned = vector3d;
            Vector3d direction = pos.sub((Vector3dc)this.positionUntilAligned, new Vector3d());
            Intrinsics.checkNotNull((Object)direction);
            physShip.applyInvariantForce((Vector3dc)direction);
        }
        if (this.aligning && Math.abs(this.angleUntilAligned) > 0.01) {
            if (this.angleUntilAligned < 0.3 && this.angleUntilAligned > 0.0) {
                this.angleUntilAligned = 0.3;
            }
            if (this.angleUntilAligned > -0.3 && this.angleUntilAligned < 0.0) {
                this.angleUntilAligned = -0.3;
            }
            Vector3d idealOmega = new Vector3d(invRotationAxisAngle.x, invRotationAxisAngle.y, invRotationAxisAngle.z).mul(-this.angleUntilAligned).mul(EurekaConfig.SERVER.getStabilizationSpeed());
            Vector3d idealTorque = moiTensor.transform(idealOmega);
            Intrinsics.checkNotNull((Object)idealTorque);
            physShip.applyInvariantTorque((Vector3dc)idealTorque);
        }
        boolean bl = validPlayer = (controllingPlayer = (SeatedControllingPlayer)ship.getAttachment(SeatedControllingPlayer.class)) != null && !this.getAnchored();
        if (this.getAnchored()) {
            if (this.isCruising) {
                this.isCruising = false;
                this.showCruiseStatus();
            }
            physShip.setStatic(true);
            return;
        }
        StabilizeKt.stabilize((PhysShipImpl)physShip, omega, vel, physShip, !validPlayer && !this.aligning, !validPlayer);
        Vector3d idealUpwardVel = null;
        idealUpwardVel = new Vector3d(0.0, 0.0, 0.0);
        if (validPlayer) {
            SeatedControllingPlayer seatedControllingPlayer = controllingPlayer;
            Intrinsics.checkNotNull((Object)seatedControllingPlayer);
            SeatedControllingPlayer player = seatedControllingPlayer;
            ControlData currentControlData = this.getControlData(player);
            if (!this.isCruising) {
                this.controlData = currentControlData;
            }
            this.wasCruisePressed = player.getCruise();
        } else if (!this.isCruising) {
            this.controlData = null;
            this.oldSpeed = 0.0;
        }
        ControlData controlData = this.controlData;
        if (controlData != null) {
            ControlData control = controlData;
            boolean bl2 = false;
            this.applyPlayerControl(control, (PhysShipImpl)physShip);
            idealUpwardVel = this.getPlayerUpwardVel(control, mass);
        }
        double idealUpwardForce = (idealUpwardVel.y() - vel.y() - -10.0 / EurekaConfig.SERVER.getElevationSnappiness()) * mass * EurekaConfig.SERVER.getElevationSnappiness();
        physShip.applyInvariantForce((Vector3dc)new Vector3d(0.0, Math.min(balloonForceProvided, Math.max(idealUpwardForce, 0.0)) + vel.y() * -mass, 0.0));
        physShip.setStatic(this.getAnchored());
    }

    private final ControlData getControlData(SeatedControllingPlayer player) {
        ControlData currentControlData = ControlData.Companion.create(player);
        if (!this.wasCruisePressed && player.getCruise()) {
            this.isCruising = !this.isCruising;
            this.showCruiseStatus();
        } else if (!(player.getCruise() || !this.isCruising || player.getLeftImpulse() == 0.0f && !player.getSprintOn() && player.getUpImpulse() == 0.0f && player.getForwardImpulse() == 0.0f || Intrinsics.areEqual((Object)currentControlData, (Object)this.controlData))) {
            this.isCruising = false;
            this.showCruiseStatus();
        }
        return currentControlData;
    }

    private final void applyPlayerControl(ControlData control, PhysShipImpl physShip) {
        boolean isBelowMaxTurnSpeed;
        ServerShip serverShip = this.ship;
        if (serverShip == null) {
            return;
        }
        ServerShip ship = serverShip;
        ShipTransform transform = physShip.getTransform();
        AABBdc aabb = ship.getWorldAABB();
        Vector3dc center = transform.getPositionInWorld();
        Matrix3dc moiTensor = physShip.getInertia().getMomentOfInertiaTensor();
        Vector3dc omega = physShip.getPoseVel().getOmega();
        EurekaShipControl $this$applyPlayerControl_u24lambda_u241 = this;
        boolean bl = false;
        double dist = center.distance(aabb.minX(), center.y(), aabb.minZ());
        dist = Math.max(dist, center.distance(aabb.minX(), center.y(), aabb.maxZ()));
        dist = Math.max(dist, center.distance(aabb.maxX(), center.y(), aabb.minZ()));
        dist = Math.max(dist, center.distance(aabb.maxX(), center.y(), aabb.maxZ()));
        double largestDistance = RangesKt.coerceIn((double)dist, (double)0.5, (double)EurekaConfig.SERVER.getMaxSizeForTurnSpeedPenalty());
        double maxLinearAcceleration = EurekaConfig.SERVER.getTurnAcceleration();
        double maxLinearSpeed = EurekaConfig.SERVER.getTurnSpeed() + this.extraForceAngular;
        double maxOmegaY = maxLinearSpeed / largestDistance;
        double maxAlphaY = maxLinearAcceleration / largestDistance;
        boolean bl2 = isBelowMaxTurnSpeed = Math.abs(omega.y()) < maxOmegaY;
        double normalizedAlphaYMultiplier = isBelowMaxTurnSpeed && !(control.getLeftImpulse() == 0.0f) ? (double)control.getLeftImpulse() : -RangesKt.coerceIn((double)omega.y(), (double)-1.0, (double)1.0);
        double idealAlphaY = normalizedAlphaYMultiplier * maxAlphaY;
        Vector3d vector3d = moiTensor.transform(new Vector3d(0.0, idealAlphaY, 0.0));
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transform(...)");
        physShip.applyInvariantTorque((Vector3dc)vector3d);
        physShip.applyInvariantTorque((Vector3dc)this.getPlayerControlledBanking(control, (PhysShip)physShip, moiTensor, -idealAlphaY));
        physShip.applyInvariantForce((Vector3dc)this.getPlayerForwardVel(control, physShip));
    }

    private final Vector3d getPlayerControlledBanking(ControlData control, PhysShip physShip, Matrix3dc moiTensor, double strength) {
        class_2382 class_23822 = control.getSeatInDirection().method_10163();
        Intrinsics.checkNotNullExpressionValue((Object)class_23822, (String)"getNormal(...)");
        Vector3d rotationVector = VectorConversionsMCKt.toJOMLD((class_2382)class_23822);
        physShip.getTransform().getShipToWorldRotation().transform(rotationVector);
        rotationVector.y = 0.0;
        rotationVector.mul(strength * 1.5);
        physShip.getTransform().getShipToWorldRotation().transform(moiTensor.transform(physShip.getTransform().getShipToWorldRotation().transformInverse(rotationVector)));
        return rotationVector;
    }

    private final Vector3d getPlayerForwardVel(ControlData control, PhysShipImpl physShip) {
        double scaledMass = physShip.getInertia().getShipMass() * EurekaConfig.SERVER.getSpeedMassScale();
        Vector3dc vel = physShip.getPoseVel().getVel();
        class_2382 class_23822 = control.getSeatInDirection().method_10163();
        Intrinsics.checkNotNullExpressionValue((Object)class_23822, (String)"getNormal(...)");
        Vector3d forwardVector = VectorConversionsMCKt.toJOMLD((class_2382)class_23822);
        physShip.getTransform().getShipToWorldRotation().transform(forwardVector);
        forwardVector.normalize();
        double s = 1.0 / this.smoothingATanMax(EurekaConfig.SERVER.getLinearMaxMass(), physShip.getInertia().getShipMass() * EurekaConfig.SERVER.getLinearMassScaling() + EurekaConfig.SERVER.getLinearBaseMass());
        double maxSpeed = EurekaConfig.SERVER.getLinearMaxSpeed() / (double)15;
        this.oldSpeed = Math.max(Math.min(this.oldSpeed * (1.0 - s) + (double)control.getForwardImpulse() * s, maxSpeed), -maxSpeed);
        forwardVector.mul(this.oldSpeed);
        Vector3d playerUpDirection = physShip.getTransform().getShipToWorldRotation().transform(new Vector3d(0.0, 1.0, 0.0));
        Vector3d velOrthogonalToPlayerUp = vel.sub((Vector3dc)playerUpDirection.mul(playerUpDirection.dot(vel)), new Vector3d());
        Vector3d baseForwardVel = new Vector3d((Vector3dc)forwardVector).mul(EurekaConfig.SERVER.getBaseSpeed());
        Vector3d forwardForce = new Vector3d((Vector3dc)baseForwardVel).sub((Vector3dc)velOrthogonalToPlayerUp).mul(scaledMass);
        if (!(this.extraForceLinear == 0.0)) {
            double boost = Math.max((this.extraForceLinear - (double)EurekaConfig.SERVER.getEnginePowerLinear() * EurekaConfig.SERVER.getEngineBoostOffset()) * EurekaConfig.SERVER.getEngineBoost(), 0.0);
            this.extraForceLinear += boost + boost * boost * EurekaConfig.SERVER.getEngineBoostExponentialPower();
            Vector3d idealForwardVel = new Vector3d((Vector3dc)forwardVector).mul(EurekaConfig.SERVER.getMaxCasualSpeed());
            Vector3d idealForwardForce = new Vector3d((Vector3dc)idealForwardVel).sub((Vector3dc)velOrthogonalToPlayerUp).mul(scaledMass);
            Vector3d extraForceNeeded = new Vector3d((Vector3dc)idealForwardForce).sub((Vector3dc)forwardForce);
            forwardForce.fma(Math.min(this.extraForceLinear / extraForceNeeded.length(), 1.0), (Vector3dc)extraForceNeeded);
        }
        Intrinsics.checkNotNull((Object)forwardForce);
        return forwardForce;
    }

    private final Vector3d getPlayerUpwardVel(ControlData control, double mass) {
        if (!(control.getUpImpulse() == 0.0f)) {
            double balloonForceProvided = (double)this.balloons * EurekaShipControl.Companion.getForcePerBalloon();
            Vector3d vector3d = new Vector3d(0.0, 1.0, 0.0).mul((double)control.getUpImpulse()).mul(control.getUpImpulse() < 0.0f ? EurekaConfig.SERVER.getBaseImpulseDescendRate() : EurekaConfig.SERVER.getBaseImpulseElevationRate() + this.smoothing(2.0, EurekaConfig.SERVER.getBalloonElevationMaxSpeed(), balloonForceProvided / mass));
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
            return vector3d;
        }
        return new Vector3d(0.0, 0.0, 0.0);
    }

    private final void showCruiseStatus() {
        block0: {
            String cruiseKey = this.isCruising ? "hud.vs_eureka.start_cruising" : "hud.vs_eureka.stop_cruising";
            class_1657 class_16572 = this.seatedPlayer;
            if (class_16572 == null) break block0;
            class_16572.method_7353((class_2561)new class_2588(cruiseKey), true);
        }
    }

    public final double getPowerLinear() {
        return this.powerLinear;
    }

    public final void setPowerLinear(double d) {
        this.powerLinear = d;
    }

    public final double getPowerAngular() {
        return this.powerAngular;
    }

    public final void setPowerAngular(double d) {
        this.powerAngular = d;
    }

    public final int getAnchors() {
        return this.anchors;
    }

    public final void setAnchors(int v) {
        this.anchors = v;
        this.deleteIfEmpty();
    }

    public final int getAnchorsActive() {
        return this.anchorsActive;
    }

    public final void setAnchorsActive(int n) {
        this.anchorsActive = n;
    }

    public final int getBalloons() {
        return this.balloons;
    }

    public final void setBalloons(int v) {
        this.balloons = v;
        this.deleteIfEmpty();
    }

    public final int getHelms() {
        return this.helms;
    }

    public final void setHelms(int v) {
        this.helms = v;
        this.deleteIfEmpty();
    }

    public final int getFloaters() {
        return this.floaters;
    }

    public final void setFloaters(int v) {
        this.floaters = v;
        this.deleteIfEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteIfEmpty() {
        block1: {
            if (this.helms > 0 || this.floaters > 0 || this.anchors > 0 || this.balloons > 0) break block1;
            ServerShip serverShip = this.ship;
            if (serverShip != null) {
                void $this$saveAttachment$iv;
                ServerShip serverShip2 = serverShip;
                Object value$iv = null;
                boolean $i$f$saveAttachment = false;
                $this$saveAttachment$iv.saveAttachment(EurekaShipControl.class, value$iv);
            }
        }
    }

    private final double smoothing(double smoothing, double max, double x) {
        return max - smoothing / (x + smoothing / max);
    }

    private final double smoothingATan(double smoothing, double x) {
        return Math.atan(x * smoothing) / smoothing;
    }

    private final double smoothingATanMax(double max, double x) {
        return this.smoothingATan(1.0 / (max * 0.638), x);
    }

    public void onServerTick() {
        this.extraForceLinear = this.powerLinear;
        this.powerLinear = 0.0;
        this.extraForceAngular = this.powerAngular;
        this.powerAngular = 0.0;
        this.consumed = this.physConsumption * 0.1f;
        this.physConsumption = 0.0f;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/valkyrienskies/eureka/ship/EurekaShipControl$Companion;", "", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "ship", "Lorg/valkyrienskies/eureka/ship/EurekaShipControl;", "getOrCreate", "(Lorg/valkyrienskies/core/api/ships/ServerShip;)Lorg/valkyrienskies/eureka/ship/EurekaShipControl;", "", "ALIGN_THRESHOLD", "D", "DISASSEMBLE_THRESHOLD", "GRAVITY", "getForcePerBalloon", "()D", "forcePerBalloon", "<init>", "()V", "eureka"})
    @SourceDebugExtension(value={"SMAP\nEurekaShipControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EurekaShipControl.kt\norg/valkyrienskies/eureka/ship/EurekaShipControl$Companion\n+ 2 ServerShip.kt\norg/valkyrienskies/core/api/ships/ServerShipKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,431:1\n44#2:432\n41#2:434\n1#3:433\n*S KotlinDebug\n*F\n+ 1 EurekaShipControl.kt\norg/valkyrienskies/eureka/ship/EurekaShipControl$Companion\n*L\n409#1:432\n410#1:434\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EurekaShipControl getOrCreate(@NotNull ServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            ServerShip $this$getAttachment$iv = ship;
            boolean $i$f$getAttachment = false;
            EurekaShipControl eurekaShipControl = (EurekaShipControl)$this$getAttachment$iv.getAttachment(EurekaShipControl.class);
            if (eurekaShipControl == null) {
                EurekaShipControl eurekaShipControl2;
                EurekaShipControl it = eurekaShipControl2 = new EurekaShipControl();
                boolean bl = false;
                ServerShip $this$saveAttachment$iv = ship;
                boolean $i$f$saveAttachment = false;
                $this$saveAttachment$iv.saveAttachment(EurekaShipControl.class, (Object)it);
                eurekaShipControl = eurekaShipControl2;
            }
            return eurekaShipControl;
        }

        private final double getForcePerBalloon() {
            return EurekaConfig.SERVER.getMassPerBalloon() * 10.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0082\b\u0018\u0000 -2\u00020\u0001:\u0001-B7\u0012\u0006\u0010\r\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0004\b+\u0010,J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J\u0010\u0010\t\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJB\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0015\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\"\u0010\u000e\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u001d\u001a\u0004\b\u001e\u0010\u0007\"\u0004\b\u001f\u0010 R\"\u0010\u000f\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u001d\u001a\u0004\b!\u0010\u0007\"\u0004\b\"\u0010 R\u0017\u0010\r\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010#\u001a\u0004\b$\u0010\u0004R\"\u0010\u0011\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010%\u001a\u0004\b&\u0010\f\"\u0004\b'\u0010(R\"\u0010\u0010\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u001d\u001a\u0004\b)\u0010\u0007\"\u0004\b*\u0010 \u00a8\u0006."}, d2={"Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "", "Lnet/minecraft/class_2350;", "component1", "()Lnet/minecraft/class_2350;", "", "component2", "()F", "component3", "component4", "", "component5", "()Z", "seatInDirection", "forwardImpulse", "leftImpulse", "upImpulse", "sprintOn", "copy", "(Lnet/minecraft/class_2350;FFFZ)Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "F", "getForwardImpulse", "setForwardImpulse", "(F)V", "getLeftImpulse", "setLeftImpulse", "Lnet/minecraft/class_2350;", "getSeatInDirection", "Z", "getSprintOn", "setSprintOn", "(Z)V", "getUpImpulse", "setUpImpulse", "<init>", "(Lnet/minecraft/class_2350;FFFZ)V", "Companion", "eureka"})
    private static final class ControlData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final class_2350 seatInDirection;
        private float forwardImpulse;
        private float leftImpulse;
        private float upImpulse;
        private boolean sprintOn;

        public ControlData(@NotNull class_2350 seatInDirection, float forwardImpulse, float leftImpulse, float upImpulse, boolean sprintOn) {
            Intrinsics.checkNotNullParameter((Object)seatInDirection, (String)"seatInDirection");
            this.seatInDirection = seatInDirection;
            this.forwardImpulse = forwardImpulse;
            this.leftImpulse = leftImpulse;
            this.upImpulse = upImpulse;
            this.sprintOn = sprintOn;
        }

        public /* synthetic */ ControlData(class_2350 class_23502, float f, float f2, float f3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                f = 0.0f;
            }
            if ((n & 4) != 0) {
                f2 = 0.0f;
            }
            if ((n & 8) != 0) {
                f3 = 0.0f;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(class_23502, f, f2, f3, bl);
        }

        @NotNull
        public final class_2350 getSeatInDirection() {
            return this.seatInDirection;
        }

        public final float getForwardImpulse() {
            return this.forwardImpulse;
        }

        public final void setForwardImpulse(float f) {
            this.forwardImpulse = f;
        }

        public final float getLeftImpulse() {
            return this.leftImpulse;
        }

        public final void setLeftImpulse(float f) {
            this.leftImpulse = f;
        }

        public final float getUpImpulse() {
            return this.upImpulse;
        }

        public final void setUpImpulse(float f) {
            this.upImpulse = f;
        }

        public final boolean getSprintOn() {
            return this.sprintOn;
        }

        public final void setSprintOn(boolean bl) {
            this.sprintOn = bl;
        }

        @NotNull
        public final class_2350 component1() {
            return this.seatInDirection;
        }

        public final float component2() {
            return this.forwardImpulse;
        }

        public final float component3() {
            return this.leftImpulse;
        }

        public final float component4() {
            return this.upImpulse;
        }

        public final boolean component5() {
            return this.sprintOn;
        }

        @NotNull
        public final ControlData copy(@NotNull class_2350 seatInDirection, float forwardImpulse, float leftImpulse, float upImpulse, boolean sprintOn) {
            Intrinsics.checkNotNullParameter((Object)seatInDirection, (String)"seatInDirection");
            return new ControlData(seatInDirection, forwardImpulse, leftImpulse, upImpulse, sprintOn);
        }

        public static /* synthetic */ ControlData copy$default(ControlData controlData, class_2350 class_23502, float f, float f2, float f3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                class_23502 = controlData.seatInDirection;
            }
            if ((n & 2) != 0) {
                f = controlData.forwardImpulse;
            }
            if ((n & 4) != 0) {
                f2 = controlData.leftImpulse;
            }
            if ((n & 8) != 0) {
                f3 = controlData.upImpulse;
            }
            if ((n & 0x10) != 0) {
                bl = controlData.sprintOn;
            }
            return controlData.copy(class_23502, f, f2, f3, bl);
        }

        @NotNull
        public String toString() {
            return "ControlData(seatInDirection=" + this.seatInDirection + ", forwardImpulse=" + this.forwardImpulse + ", leftImpulse=" + this.leftImpulse + ", upImpulse=" + this.upImpulse + ", sprintOn=" + this.sprintOn + ")";
        }

        public int hashCode() {
            int result = this.seatInDirection.hashCode();
            result = result * 31 + Float.hashCode(this.forwardImpulse);
            result = result * 31 + Float.hashCode(this.leftImpulse);
            result = result * 31 + Float.hashCode(this.upImpulse);
            int n = this.sprintOn ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ControlData)) {
                return false;
            }
            ControlData controlData = (ControlData)other;
            if (this.seatInDirection != controlData.seatInDirection) {
                return false;
            }
            if (Float.compare(this.forwardImpulse, controlData.forwardImpulse) != 0) {
                return false;
            }
            if (Float.compare(this.leftImpulse, controlData.leftImpulse) != 0) {
                return false;
            }
            if (Float.compare(this.upImpulse, controlData.upImpulse) != 0) {
                return false;
            }
            return this.sprintOn == controlData.sprintOn;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData$Companion;", "", "Lorg/valkyrienskies/mod/api/SeatedControllingPlayer;", "player", "Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "create", "(Lorg/valkyrienskies/mod/api/SeatedControllingPlayer;)Lorg/valkyrienskies/eureka/ship/EurekaShipControl$ControlData;", "<init>", "()V", "eureka"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ControlData create(@NotNull SeatedControllingPlayer player) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return new ControlData(player.getSeatInDirection(), player.getForwardImpulse(), player.getLeftImpulse(), player.getUpImpulse(), player.getSprintOn());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

