/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.neptune.ability.AbilityData;
import com.iafenvoy.sow.item.SongCubeItem;
import com.iafenvoy.sow.item.block.SongCubeBlock;
import com.iafenvoy.sow.registry.power.SowAbilityCategories;
import com.iafenvoy.sow.world.song.SongChunkData;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber
public final class SowCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sow").requires(source -> source.isPlayer() && source.hasPermission(source.getServer().isDedicatedServer() ? 4 : 0))).then(Commands.literal((String)"power").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"use").executes(SowCommand::useSong))).then(Commands.literal((String)"enable").executes(SowCommand::enableSong))).then(Commands.literal((String)"disable").executes(SowCommand::disableSong))))).then(Commands.literal((String)"chunk").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerPlayer player = source.getPlayerOrException();
            source.sendSuccess(() -> SowCommand.lambda$registerCommand$1((Player)player), false);
            return 1;
        })));
    }

    public static int useSong(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockItem blockItem;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        ItemStack stack = source.getPlayerOrException().getMainHandItem();
        Object object = stack.getItem();
        if (object instanceof BlockItem && (object = (blockItem = (BlockItem)object).getBlock()) instanceof SongCubeBlock) {
            SongCubeBlock songCube = (SongCubeBlock)((Object)object);
            for (ServerPlayer player : players) {
                AbilityData.get((LivingEntity)player).get(songCube.getCategory()).setActiveAbility((LivingEntity)player, SongCubeItem.getPower(stack));
            }
            source.sendSuccess(() -> Component.translatable((String)"command.sow.use_song.success"), false);
            return 1;
        }
        source.sendSuccess(() -> Component.translatable((String)"command.sow.use_song.invalid"), false);
        return 0;
    }

    public static int enableSong(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        for (ServerPlayer player : players) {
            AbilityData.get((LivingEntity)player).enable((LivingEntity)player, (AbilityCategory[])SowAbilityCategories.ALL.get().toArray(AbilityCategory[]::new));
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Success!"), true);
        return 1;
    }

    public static int disableSong(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        for (ServerPlayer player : players) {
            AbilityData.get((LivingEntity)player).disable((LivingEntity)player, (AbilityCategory[])SowAbilityCategories.ALL.get().toArray(AbilityCategory[]::new));
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Success!"), true);
        return 1;
    }

    private static /* synthetic */ Component lambda$registerCommand$1(Player player) {
        return Component.nullToEmpty((String)("Remain notes: " + SongChunkData.get(player.level().getChunkAt(player.blockPosition())).getRemainNotes()));
    }
}

