/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.compat;

import com.iafenvoy.sow.SongsOfWar;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class LitematicaHelper {
    private static final String EXTRACT_PATH = "./schematics/songs-of-war/";
    private static final List<String> FILES = List.of("shrine.litematic");

    public static void extractFile() {
        new File(EXTRACT_PATH).mkdirs();
        for (String file : FILES) {
            try {
                LitematicaHelper.write2File(LitematicaHelper.class.getResourceAsStream("/litematica/" + file), EXTRACT_PATH + file);
            }
            catch (Exception e) {
                SongsOfWar.LOGGER.error("Failed to extract litematica file {}.", (Object)file, (Object)e);
            }
        }
    }

    public static void write2File(InputStream is, String filePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
             BufferedInputStream bis = new BufferedInputStream(is);){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, bytesRead);
            }
            bos.flush();
        }
    }
}

