/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.compat.tooltips;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.neptune.ability.type.Ability;
import com.iafenvoy.neptune.ability.type.DummyAbility;
import com.iafenvoy.sow.item.SongCubeItem;
import com.iafenvoy.sow.item.block.SongCubeBlock;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SongPowerComponent
implements ClientTooltipComponent {
    @Nullable
    private final AbilityCategory category;
    private final Ability<?> ability;

    public SongPowerComponent(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof SongCubeBlock) {
            SongCubeBlock songCube = (SongCubeBlock)item;
            this.category = songCube.getCategory();
            this.ability = SongCubeItem.getPower(stack);
        } else {
            this.category = null;
            this.ability = DummyAbility.EMPTY;
        }
    }

    public int getHeight() {
        return 10;
    }

    public int getWidth(Font textRenderer) {
        return 12 + textRenderer.width((FormattedText)Component.translatable((String)this.ability.getTranslateKey()));
    }

    public void renderImage(Font textRenderer, int x, int y, @NotNull GuiGraphics context) {
        Objects.requireNonNull(textRenderer);
        int lineY = y - 9 - 1;
        MutableComponent mutableText = Component.translatable((String)this.ability.getTranslateKey());
        if (this.category != null) {
            mutableText = this.category.appendColor(mutableText);
        }
        Objects.requireNonNull(textRenderer);
        context.blit(this.ability.getIconTexture(), x, (lineY += 9 + 1) - 1, 10, 10, 0.0f, 0.0f, 16, 16, 16, 16);
        context.drawString(textRenderer, (Component)mutableText, x + 12, lineY, -1, true);
    }
}

