/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.config;

import com.iafenvoy.jupiter.interfaces.IConfigEnumEntry;
import com.iafenvoy.sow.config.SowCommonConfig;
import java.time.LocalDate;
import org.jetbrains.annotations.NotNull;

public class Anniversary {
    public static boolean shouldInvoke() {
        Object object = SowCommonConfig.INSTANCE.common.anniversary.getValue();
        if (object instanceof InvokeType) {
            InvokeType type = (InvokeType)((Object)object);
            if (type == InvokeType.TRUE) {
                return true;
            }
            if (type == InvokeType.FALSE) {
                return false;
            }
            return Anniversary.isDateInRange(LocalDate.now());
        }
        return false;
    }

    public static boolean isDateInRange(LocalDate currentDate) {
        LocalDate startDate = LocalDate.of(currentDate.getYear(), 11, 23);
        LocalDate endDate = LocalDate.of(currentDate.getYear(), 11, 29);
        return !currentDate.isBefore(startDate) && !currentDate.isAfter(endDate);
    }

    public static enum InvokeType implements IConfigEnumEntry
    {
        TRUE,
        NORMAL,
        FALSE;


        public String getName() {
            return this.name();
        }

        @NotNull
        public IConfigEnumEntry getByName(String s) {
            return InvokeType.valueOf(s);
        }

        public IConfigEnumEntry cycle(boolean b) {
            InvokeType[] types = InvokeType.values();
            return types[(this.ordinal() + (b ? 1 : -1)) % types.length];
        }
    }
}

