/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.data;

import com.iafenvoy.neptune.util.RandomHelper;
import com.iafenvoy.sow.item.SowSpawnEggItem;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.neoforged.neoforge.registries.DeferredHolder;

public record ArdoniType(String id, boolean dark, int primaryColor, IntList altColors) {
    private static final Map<String, ArdoniType> BY_ID = new HashMap<String, ArdoniType>();
    public static final ArdoniType NONE = new ArdoniType("none", false, -1, new int[0]);
    public static final ArdoniType VOLTARIS = new ArdoniType("voltaris", true, -65536, new int[0]);
    public static final ArdoniType SENDARIS = new ArdoniType("sendaris", false, -16776961, -16711681);
    public static final ArdoniType NESTORIS = new ArdoniType("nestoris", false, -256, -1008807);
    public static final ArdoniType KALTARIS = new ArdoniType("kaltaris", false, -16711936, new int[0]);
    public static final ArdoniType MENDORIS = new ArdoniType("mendoris", false, -6283024, -1425417);

    public ArdoniType(String id, boolean dark, int primaryColor, int ... altColors) {
        this(id, dark, primaryColor, IntList.of((int[])altColors));
        BY_ID.put(id, this);
    }

    public int getColor(long seed) {
        Random random = new Random(seed);
        if (this.altColors.isEmpty() || random.nextInt(3) > 0) {
            return this.primaryColor;
        }
        return (Integer)RandomHelper.randomOne((Random)random, (List)this.altColors);
    }

    public static ArdoniType byId(String id) {
        return BY_ID.getOrDefault(id, NONE);
    }

    public static ArdoniType random() {
        return (ArdoniType)RandomHelper.randomOne(new ArrayList<ArdoniType>(BY_ID.values()));
    }

    public SowSpawnEggItem createSpawnEgg(DeferredHolder<EntityType<?>, ? extends EntityType<? extends Mob>> type) {
        return new SowSpawnEggItem(type, -7829368, this.primaryColor);
    }

    public Component formatName(String prefix) {
        if (this == NONE || this.id.isEmpty()) {
            return Component.literal((String)prefix);
        }
        return Component.translatable((String)"ardoniType.sow.%s".formatted(this.id), (Object[])new Object[]{Component.literal((String)prefix)});
    }
}

