/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.entity.ardoni;

import com.iafenvoy.sow.config.Anniversary;
import com.iafenvoy.sow.data.ArdoniType;
import com.iafenvoy.sow.entity.ardoni.AbstractArdoniEntity;
import com.iafenvoy.sow.entity.util.Flatable;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TygrenEntity
extends AbstractArdoniEntity
implements Flatable {
    public static final ResourceLocation TEXTURE = ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/ardoni/special/tygren.png");
    public static final ResourceLocation TEXTURE_MARKER = ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/ardoni/special/tygren_marker.png");
    public static final int COLOR = -65536;
    private static final EntityDataAccessor<Boolean> FLAT = SynchedEntityData.defineId(TygrenEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public TygrenEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLAT, (Object)false);
        if (Anniversary.shouldInvoke()) {
            this.flat();
        }
    }

    public ResourceLocation getTextureId() {
        return TEXTURE;
    }

    public Optional<ResourceLocation> getMarkerTextureId() {
        return Optional.ofNullable(TEXTURE_MARKER);
    }

    @Override
    public int getColor() {
        return -65536;
    }

    @Override
    public ArdoniType getArdoniType() {
        return ArdoniType.VOLTARIS;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        boolean success = super.hurt(source, amount);
        if (success && source.is(DamageTypes.FALLING_ANVIL)) {
            this.flat();
        }
        return success;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("Flat", this.isFlat());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.getBoolean("Flat")) {
            this.flat();
        }
    }

    private void flat() {
        this.entityData.set(FLAT, (Object)true);
    }

    @Override
    public boolean isFlat() {
        return (Boolean)this.entityData.get(FLAT);
    }
}

