/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.entity.felina;

import com.iafenvoy.neptune.util.RandomHelper;
import com.iafenvoy.sow.entity.felina.AbstractFelinaEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FeldenEntity
extends AbstractFelinaEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(FeldenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public FeldenEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)1);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int type) {
        this.entityData.set(VARIANT, (Object)type);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("variant", this.getVariant());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("variant")) {
            this.setVariant(nbt.getInt("variant"));
        } else {
            this.setVariant(RandomHelper.nextInt((int)1, (int)2));
        }
    }

    public ResourceLocation getTextureId() {
        return ResourceLocation.tryBuild((String)"sow", (String)("textures/entity/felina/felden_" + this.getVariant() + ".png"));
    }

    public float getScale() {
        return 1.05f;
    }
}

