/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.entity.human;

import com.iafenvoy.neptune.util.RandomHelper;
import com.iafenvoy.sow.entity.human.AbstractHumanEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CivilianEntity
extends AbstractHumanEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(CivilianEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public CivilianEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)1);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("variant", this.getVariant());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("variant")) {
            this.setVariant(nbt.getInt("variant"));
        } else {
            this.setVariant(RandomHelper.nextInt((int)1, (int)3));
        }
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        SpawnGroupData data = super.finalizeSpawn(world, difficulty, spawnReason, entityData);
        this.setVariant(RandomHelper.nextInt((int)1, (int)3));
        return data;
    }

    public ResourceLocation getTextureId() {
        return switch (this.getVariant()) {
            case 2 -> ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/human/hogtown_civilian_1.png");
            case 3 -> ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/human/hogtown_civilian_2.png");
            default -> ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/human/biggerton_civilian.png");
        };
    }
}

