/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.entity.magnorite;

import com.iafenvoy.sow.entity.magnorite.AbstractMagnoriteEntity;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagnoriteEntity
extends AbstractMagnoriteEntity {
    protected static final EntityDataAccessor<Long> MARKER_SEED = SynchedEntityData.defineId(MagnoriteEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);

    public MagnoriteEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MARKER_SEED, (Object)0L);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putLong("markerSeed", this.getMarkerSeed());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("markerSeed")) {
            this.setMarkerSeed(nbt.getLong("markerSeed"));
        } else {
            this.setMarkerSeed(this.getRandom().nextLong());
        }
    }

    public long getMarkerSeed() {
        return (Long)this.entityData.get(MARKER_SEED);
    }

    public void setMarkerSeed(long markerSeed) {
        this.entityData.set(MARKER_SEED, (Object)markerSeed);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        SpawnGroupData data = super.finalizeSpawn(world, difficulty, spawnReason, entityData);
        this.setMarkerSeed(this.getRandom().nextLong());
        return data;
    }

    public ResourceLocation getTextureId() {
        return ResourceLocation.tryBuild((String)"sow", (String)"textures/white.png");
    }

    public Optional<ResourceLocation> getMarkerTextureId() {
        return Optional.empty();
    }
}

