/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.entity.power;

import com.iafenvoy.neptune.object.DamageUtil;
import com.iafenvoy.neptune.world.FakeExplosionBehavior;
import com.iafenvoy.sow.entity.power.SupporekesisControllable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AggroProjectileEntity
extends AbstractArrow
implements SupporekesisControllable {
    private static final EntityDataAccessor<Integer> DISAPPEAR_CD = SynchedEntityData.defineId(AggroProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> EXPLODE = SynchedEntityData.defineId(AggroProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private float damageMultiplier = 1.0f;

    protected AggroProjectileEntity(EntityType<? extends AggroProjectileEntity> entityType, Level world) {
        super(entityType, world);
        this.setNoPhysics(true);
        this.setNoGravity(true);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DISAPPEAR_CD, (Object)-1);
        builder.define(EXPLODE, (Object)false);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("disappear_cd", this.getDisappearCd());
        nbt.putBoolean("explode", this.getExplode());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setDisappearCd(nbt.getInt("disappear_cd"));
        this.setExplode(nbt.getBoolean("explode"));
    }

    @NotNull
    protected Entity ownerOrSelf() {
        return this.getOwner() == null ? this : this.getOwner();
    }

    public float transformDamage(float base) {
        return base * this.damageMultiplier;
    }

    public void tick() {
        int cd;
        super.tick();
        Vec3 vec3d = this.getDeltaMovement();
        double d = vec3d.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)vec3d.x, (double)vec3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3d.y, (double)d) * 57.2957763671875));
        if (this.getY() > 1000.0 || this.tickCount > 1200) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if ((cd = this.getDisappearCd()) == 0) {
            if (this.getExplode()) {
                this.getCommandSenderWorld().explode((Entity)this, DamageUtil.build((Entity)this.ownerOrSelf(), (ResourceKey)DamageTypes.EXPLOSION), (ExplosionDamageCalculator)new FakeExplosionBehavior(), this.position(), 0.0f, false, Level.ExplosionInteraction.NONE);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        } else if (cd > 0) {
            this.setDisappearCd(cd - 1);
        }
    }

    public boolean getExplode() {
        return (Boolean)this.entityData.get(EXPLODE);
    }

    public int getDisappearCd() {
        return (Integer)this.entityData.get(DISAPPEAR_CD);
    }

    public void setExplode(boolean explode) {
        this.entityData.set(EXPLODE, (Object)explode);
    }

    public void setDisappearCd(int cd) {
        this.entityData.set(DISAPPEAR_CD, (Object)cd, true);
    }

    public void setCritArrow(boolean b) {
        this.damageMultiplier = 1.5f;
    }

    @NotNull
    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.FIRE_CHARGE);
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    @Override
    public void setDisappearCd(int disappearDelay, boolean explode) {
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.hurtMarked = true;
        this.setDisappearCd(disappearDelay);
        this.setExplode(explode);
    }
}

