/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.entity.power;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ProteCloneEntity
extends Mob {
    private static final EntityDataAccessor<Integer> DISAPPEAR_CD = SynchedEntityData.defineId(ProteCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ProteCloneEntity(EntityType<? extends Mob> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DISAPPEAR_CD, (Object)-1);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setDisappearCd(nbt.getInt("disappear_cd"));
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("disappear_cd", this.getDisappearCd());
    }

    public int getDisappearCd() {
        return (Integer)this.entityData.get(DISAPPEAR_CD);
    }

    public void setDisappearCd(int cd) {
        this.entityData.set(DISAPPEAR_CD, (Object)cd);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            return;
        }
        int cd = this.getDisappearCd();
        if (cd == 0) {
            this.remove(Entity.RemovalReason.DISCARDED);
        } else if (cd > 0) {
            this.setDisappearCd(cd - 1);
        }
    }

    public boolean isPickable() {
        return true;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        this.remove(Entity.RemovalReason.KILLED);
        return true;
    }
}

