/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.entity.power;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class SupporoSpikeEntity
extends Entity {
    private static final EntityDataAccessor<BlockState> BLOCK_STATE = SynchedEntityData.defineId(SupporoSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    private static final EntityDataAccessor<Boolean> ABSOLUTE_ROTATION = SynchedEntityData.defineId(SupporoSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Vector3f> ROTATION = SynchedEntityData.defineId(SupporoSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.defineId(SupporoSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.defineId(SupporoSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public SupporoSpikeEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(BLOCK_STATE, (Object)Blocks.AIR.defaultBlockState());
        builder.define(ABSOLUTE_ROTATION, (Object)false);
        builder.define(ROTATION, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
        builder.define(SCALE, (Object)Float.valueOf(1.0f));
        builder.define(DURATION, (Object)20);
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.setBlockState(NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)nbt.getCompound("block_state")));
        this.setAbsoluteRotation(nbt.getBoolean("absolute_rotation"));
        this.setRotation(new Vector3f(nbt.getFloat("rotation_x"), nbt.getFloat("rotation_y"), nbt.getFloat("rotation_z")));
        this.setScale(nbt.getFloat("scale"));
        this.setDuration(nbt.getInt("duration"));
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.put("block_state", (Tag)NbtUtils.writeBlockState((BlockState)this.getBlockState()));
        nbt.putBoolean("absolute_rotation", this.isAbsoluteRotation());
        Vector3f rotation = this.getRotation();
        nbt.putFloat("rotation_x", rotation.x);
        nbt.putFloat("rotation_y", rotation.y);
        nbt.putFloat("rotation_z", rotation.z);
        nbt.putFloat("scale", this.getScale());
        nbt.putInt("duration", this.getDuration());
    }

    public void tick() {
        super.tick();
        int d = this.getDuration();
        if (d <= 0) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        this.setDuration(d - 1);
    }

    public Quaternionf getRotationQuaternion() {
        Vector3f rotation = this.getRotation();
        if (this.isAbsoluteRotation()) {
            return new Quaternionf().rotateX(rotation.x).rotationY(rotation.y).rotationZ(rotation.z);
        }
        return new Quaternionf().rotateX(rotation.x).rotateLocalY(rotation.y).rotateLocalZ(rotation.z);
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(BLOCK_STATE);
    }

    public void setBlockState(BlockState state) {
        this.entityData.set(BLOCK_STATE, (Object)state);
    }

    public boolean isAbsoluteRotation() {
        return (Boolean)this.entityData.get(ABSOLUTE_ROTATION);
    }

    public void setAbsoluteRotation(boolean absoluteRotation) {
        this.entityData.set(ABSOLUTE_ROTATION, (Object)absoluteRotation);
    }

    public Vector3f getRotation() {
        return (Vector3f)this.entityData.get(ROTATION);
    }

    public void setRotation(Vector3f rotation) {
        this.entityData.set(ROTATION, (Object)rotation);
    }

    public float getScale() {
        return ((Float)this.entityData.get(SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.entityData.set(SCALE, (Object)Float.valueOf(scale));
    }

    public int getDuration() {
        return (Integer)this.entityData.get(DURATION);
    }

    public void setDuration(int duration) {
        this.entityData.set(DURATION, (Object)duration);
    }
}

