/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.entity.zombie;

import com.iafenvoy.neptune.util.RandomHelper;
import com.iafenvoy.sow.entity.zombie.AbstractZombieEntity;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SowHuskEntity
extends AbstractZombieEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(SowHuskEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public SowHuskEntity(EntityType<? extends Zombie> entityType, Level world) {
        super(entityType, world);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)1);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("variant", this.getVariant());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("variant")) {
            this.setVariant(nbt.getInt("variant"));
        } else {
            this.setVariant(RandomHelper.nextInt((int)1, (int)13));
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        SpawnGroupData data = super.finalizeSpawn(world, difficulty, spawnReason, entityData);
        this.setVariant(RandomHelper.nextInt((int)1, (int)13));
        return data;
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public ResourceLocation getTextureId() {
        return ResourceLocation.tryBuild((String)"sow", (String)("textures/entity/zombie/husk_" + this.getVariant() + ".png"));
    }

    public Optional<ResourceLocation> getMarkerTextureId() {
        return Optional.ofNullable(ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/zombie/eye.png"));
    }

    protected boolean isSunSensitive() {
        return false;
    }
}

