/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item.block;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.neptune.ability.type.Ability;
import com.iafenvoy.sow.Constants;
import com.iafenvoy.sow.Proxies;
import com.iafenvoy.sow.item.SongCubeItem;
import com.iafenvoy.sow.item.block.entity.SongCubeBlockEntity;
import com.iafenvoy.sow.registry.power.SowAbilityCategories;
import com.mojang.serialization.MapCodec;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SongCubeBlock
extends BaseEntityBlock {
    private static final MapCodec<SongCubeBlock> CODEC = SongCubeBlock.simpleCodec(x -> new SongCubeBlock(SowAbilityCategories.AGGRESSIUM));
    public static final List<SongCubeBlock> BLOCKS = new LinkedList<SongCubeBlock>();
    private final DeferredHolder<AbilityCategory, AbilityCategory> category;

    public SongCubeBlock(DeferredHolder<AbilityCategory, AbilityCategory> category) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK).noOcclusion().emissiveRendering((state, world, pos) -> true).lightLevel(state -> 15).instabreak().noLootTable());
        this.category = category;
        BLOCKS.add(this);
    }

    public void playerDestroy(@NotNull Level world, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack tool) {
        super.playerDestroy(world, player, pos, state, blockEntity, tool);
        if (blockEntity instanceof SongCubeBlockEntity) {
            SongCubeBlockEntity songCubeBlockEntity = (SongCubeBlockEntity)blockEntity;
            Ability<?> power = songCubeBlockEntity.getPower();
            SongCubeBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)SongCubeItem.getStack(power));
        }
    }

    public AbilityCategory getCategory() {
        return (AbilityCategory)this.category.get();
    }

    public static Block getBlock(AbilityCategory category) {
        return BLOCKS.stream().filter(x -> x.category.get() == category).findFirst().map(Block.class::cast).orElse(Blocks.AIR);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.25, (double)0.625);
    }

    @NotNull
    public VoxelShape getInteractionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.25, (double)0.625);
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Ability<?> power = SongCubeItem.getPower(stack);
        tooltipComponents.add((Component)((AbilityCategory)this.category.get()).appendColor(Component.translatable((String)power.getTranslateKey())));
        Constants.LAST_SONG_POWER_TOOLTIP = power.getTranslateKey();
        if (power.isExperimental()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.sow.song.experimental"));
        }
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof SongCubeBlockEntity) {
            SongCubeBlockEntity blockEntity2 = (SongCubeBlockEntity)blockEntity;
            blockEntity2.setPower(SongCubeItem.getPower(itemStack));
        }
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SongCubeBlockEntity) {
            SongCubeBlockEntity blockEntity2 = (SongCubeBlockEntity)blockEntity;
            SongCubeItem.appendComponent(blockEntity2.getPower(), stack);
        }
        return stack;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new SongCubeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level world, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof SongCubeBlockEntity) {
                SongCubeBlockEntity songCubeBlockEntity = (SongCubeBlockEntity)blockEntity;
                Proxies.songCubeSoundManager.startPlaying(songCubeBlockEntity.getBlockPos(), songCubeBlockEntity.getCategory());
            }
        };
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

