/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item.block;

import com.iafenvoy.sow.item.block.entity.WallsOfTimeBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WallsOfTimeBlock
extends BaseEntityBlock {
    private static final MapCodec<WallsOfTimeBlock> CODEC = WallsOfTimeBlock.simpleCodec(WallsOfTimeBlock::new);

    public WallsOfTimeBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new WallsOfTimeBlockEntity(pos, state);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, BlockHitResult hitResult) {
        Direction direction = hitResult.getDirection();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WallsOfTimeBlockEntity) {
            WallsOfTimeBlockEntity blockEntity2 = (WallsOfTimeBlockEntity)blockEntity;
            if (stack.is(Items.WRITTEN_BOOK) && direction.getAxis() != Direction.Axis.Y) {
                WrittenBookContent content = (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT);
                if (content != null) {
                    blockEntity2.getContents().withContent(stack.copy()).withDirection(hitResult.getDirection());
                    level.sendBlockUpdated(pos, state, state, 0);
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (stack.is(Items.WRITABLE_BOOK)) {
                player.setItemInHand(hand, blockEntity2.getContents().getContent().copy());
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

