/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item.block.entity;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.neptune.ability.type.Ability;
import com.iafenvoy.neptune.ability.type.DummyAbility;
import com.iafenvoy.neptune.registry.NeptuneRegistries;
import com.iafenvoy.sow.Proxies;
import com.iafenvoy.sow.item.block.SongCubeBlock;
import com.iafenvoy.sow.registry.SowBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SongCubeBlockEntity
extends BlockEntity {
    private Ability<?> power = DummyAbility.EMPTY;

    public SongCubeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SowBlockEntities.SONG_CUBE.get(), pos, state);
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.power = (Ability)NeptuneRegistries.ABILITY.get(ResourceLocation.tryParse((String)nbt.getString("songPower")));
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (this.power != null) {
            nbt.putString("songPower", this.power.getId().toString());
        }
    }

    public void setPower(Ability<?> power) {
        this.power = power;
    }

    public Ability<?> getPower() {
        return this.power;
    }

    public void setRemoved() {
        super.setRemoved();
        Proxies.songCubeSoundManager.destroy(this.worldPosition);
    }

    public AbilityCategory getCategory() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof SongCubeBlock) {
            SongCubeBlock block2 = (SongCubeBlock)block;
            return block2.getCategory();
        }
        throw new IllegalStateException("This is not a song cube block!");
    }
}

