/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item.block.entity;

import com.iafenvoy.sow.SongsOfWar;
import com.iafenvoy.sow.registry.SowBlockEntities;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class TemporaryTransparentBlockEntity
extends BlockEntity {
    private BlockState state = Blocks.AIR.defaultBlockState();
    private int tick = -1;

    public TemporaryTransparentBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SowBlockEntities.TEMPORARY.get(), pos, state);
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.setState(BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("state")).resultOrPartial(arg_0 -> ((Logger)SongsOfWar.LOGGER).debug(arg_0)).orElse(Blocks.AIR.defaultBlockState()));
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("state", (Tag)BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getState()).resultOrPartial(arg_0 -> ((Logger)SongsOfWar.LOGGER).debug(arg_0)).orElse(new CompoundTag()));
    }

    public BlockState getState() {
        return this.state;
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TemporaryTransparentBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        int tick = blockEntity.getTick();
        if (tick <= 0) {
            BlockState s = blockEntity.getState();
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            if (s != null) {
                world.setBlockAndUpdate(pos, s);
            }
        } else {
            blockEntity.setTick(tick - 1);
        }
    }
}

