/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.mixin;

import com.iafenvoy.sow.config.SowCommonConfig;
import com.iafenvoy.sow.data.BeaconData;
import com.iafenvoy.sow.network.payload.BeaconTeleportS2CPayload;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BeaconBlock.class})
public abstract class BeaconBlockMixin
extends BaseEntityBlock {
    protected BeaconBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"useWithoutItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleUse(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        BeaconData beaconData;
        Optional<BeaconData.SingleBeaconData> optional;
        ServerLevel serverWorld;
        block6: {
            block5: {
                if (!((Boolean)SowCommonConfig.INSTANCE.common.enableBeaconTp.getValue()).booleanValue()) {
                    return;
                }
                if (!(level instanceof ServerLevel)) break block5;
                serverWorld = (ServerLevel)level;
                if (player instanceof ServerPlayer) break block6;
            }
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (level.getBlockEntity(pos) instanceof BeaconBlockEntity && (optional = (beaconData = BeaconData.getInstance(serverWorld)).get(pos)).isPresent()) {
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new BeaconTeleportS2CPayload(pos, beaconData), (CustomPacketPayload[])new CustomPacketPayload[0]);
            cir.setReturnValue((Object)InteractionResult.CONSUME);
        }
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (stack.has(DataComponents.CUSTOM_NAME) && level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            BeaconData.getInstance(serverWorld).add(pos, stack.getHoverName());
        }
    }
}

