/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.mixin;

import com.iafenvoy.neptune.ability.AbilityData;
import com.iafenvoy.neptune.ability.type.Ability;
import com.iafenvoy.sow.registry.power.MobiliumPowers;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"updateFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleFallFlyingCheck(CallbackInfo ci) {
        Player player;
        LivingEntity entity = (LivingEntity)this;
        if (!entity.level().isClientSide && entity instanceof Player && !(player = (Player)entity).onGround() && !player.isPassenger() && !player.hasEffect(MobEffects.LEVITATION) && AbilityData.get((LivingEntity)player).abilityEnabled(new Ability[]{(Ability)MobiliumPowers.MOBILIWINGS.get()})) {
            this.setSharedFlag(7, true);
            ci.cancel();
        }
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/core/Holder;)Z", ordinal=0)})
    private boolean handleSlowFalling(boolean original) {
        LivingEntity player;
        if (this.isRemoved() || this.isNoGravity()) {
            return original;
        }
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof LivingEntity && AbilityData.get((LivingEntity)(player = (LivingEntity)livingEntityMixin)).abilityEnabled(new Ability[]{(Ability)MobiliumPowers.MOBILIGLIDE.get()})) {
            this.fallDistance = 0.0f;
            return true;
        }
        return original;
    }
}

