/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.particle;

import com.iafenvoy.sow.mixin.LevelAccessor;
import com.iafenvoy.sow.registry.SowParticles;
import com.iafenvoy.sow.util.SowMath;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class LaserParticleBuilder
extends ParticleType<LaserParticleBuilder>
implements ParticleOptions {
    public static final MapCodec<LaserParticleBuilder> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)UUIDUtil.AUTHLIB_CODEC.optionalFieldOf("owner", null).forGetter(LaserParticleBuilder::getOwner), (App)Codec.DOUBLE.fieldOf("pitch").forGetter(LaserParticleBuilder::getPitch), (App)Codec.DOUBLE.fieldOf("yaw").forGetter(LaserParticleBuilder::getYaw), (App)Codec.DOUBLE.fieldOf("distance").forGetter(LaserParticleBuilder::getDistance), (App)Codec.DOUBLE.fieldOf("offset").forGetter(LaserParticleBuilder::getOffset), (App)Codec.FLOAT.fieldOf("energyScale").forGetter(LaserParticleBuilder::getEnergyScale)).apply((Applicative)i, LaserParticleBuilder::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, LaserParticleBuilder> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries((Codec)CODEC.codec());
    @Nullable
    private final UUID owner;
    private double pitch;
    private double yaw;
    private final double distance;
    private final double offset;
    private final float energyScale;

    public LaserParticleBuilder(@Nullable UUID owner, double pitch, double yaw, double distance, double offset, float energyScale) {
        super(true);
        this.owner = owner;
        this.pitch = pitch;
        this.yaw = yaw;
        this.distance = distance;
        this.offset = offset;
        this.energyScale = energyScale;
    }

    @NotNull
    public ParticleType<?> getType() {
        return (ParticleType)SowParticles.LASER.get();
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    @NotNull
    public MapCodec<LaserParticleBuilder> codec() {
        return CODEC;
    }

    @NotNull
    public StreamCodec<? super RegistryFriendlyByteBuf, LaserParticleBuilder> streamCodec() {
        return STREAM_CODEC;
    }

    public Quaternionf getRotationQuaternion(Level world, Entity.MoveFunction positionUpdater) {
        Entity entity;
        if (this.owner != null && world != null && (entity = (Entity)((LevelAccessor)world).sow$getEntities().get(this.owner)) != null) {
            this.pitch = Math.toRadians(entity.getXRot() + 90.0f);
            this.yaw = Math.toRadians(-entity.getYHeadRot());
            Vec3 rotation = SowMath.getRotationVectorUnit(entity.getXRot(), entity.getYHeadRot());
            Vec3 pos = entity.position().add(0.0, 1.0, 0.0).add(rotation.scale(this.offset));
            positionUpdater.accept(entity, pos.x(), pos.y(), pos.z());
        }
        return new Quaternionf().rotateX((float)this.pitch).rotateLocalY((float)this.yaw);
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getOffset() {
        return this.offset;
    }

    public float getEnergyScale() {
        return this.energyScale;
    }
}

