/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.power.component;

import com.iafenvoy.neptune.ability.AbilityData;
import com.iafenvoy.neptune.ability.type.DelayAbility;
import com.iafenvoy.neptune.util.Serializable;
import com.iafenvoy.neptune.util.Tickable;
import com.iafenvoy.sow.registry.power.MobiliumPowers;
import com.iafenvoy.sow.util.SowMath;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MobiliBurstComponent
implements Serializable,
Tickable {
    public static final ResourceLocation ID = ResourceLocation.tryBuild((String)"sow", (String)"mobiliburst");
    private boolean activate;
    private int tick = -1;

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    public void setMaxTick(int tick) {
        this.tick = tick;
    }

    public void encode(CompoundTag nbt) {
        nbt.putBoolean("activate", this.activate);
        nbt.putInt("tick", this.tick);
    }

    public void decode(CompoundTag nbt) {
        this.activate = nbt.getBoolean("activate");
        this.tick = nbt.getInt("tick");
    }

    public void tick(LivingEntity living) {
        if (!this.activate) {
            return;
        }
        if (living.getDeltaMovement().length() <= 0.1) {
            this.tick = 0;
        } else {
            Vec3 pos = living.position();
            double r = 1.5;
            List entities = living.level().getEntities((Entity)living, new AABB(pos.add(new Vec3(r, r, r)), pos.subtract(new Vec3(r, r, r))), entity -> true);
            entities.forEach(entity -> {
                Vec3 dir = entity.position().subtract(living.position()).add(living.getDeltaMovement());
                entity.setDeltaMovement(SowMath.toUnit(dir.add(0.0, 0.5, 0.0)).scale(living.getDeltaMovement().length()));
                entity.hurtMarked = true;
                if (entity instanceof LivingEntity) {
                    LivingEntity l = (LivingEntity)entity;
                    l.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 40, 0), (Entity)living);
                }
            });
        }
        if (this.tick == 0) {
            this.activate = false;
            AbilityData.get((LivingEntity)living).removeComponent(ID);
            ((DelayAbility)MobiliumPowers.MOBILIBURST.get()).sendApplyMessage(living, false);
        }
        --this.tick;
    }
}

