/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.registry.power;

import com.iafenvoy.neptune.ability.type.Ability;
import com.iafenvoy.neptune.ability.type.DelayAbility;
import com.iafenvoy.neptune.ability.type.InstantAbility;
import com.iafenvoy.neptune.ability.type.PersistAbility;
import com.iafenvoy.neptune.object.DamageUtil;
import com.iafenvoy.neptune.object.EntityUtil;
import com.iafenvoy.neptune.registry.NeptuneRegistries;
import com.iafenvoy.neptune.util.RandomHelper;
import com.iafenvoy.neptune.util.Timeout;
import com.iafenvoy.neptune.world.RaycastHelper;
import com.iafenvoy.sow.config.SowCommonConfig;
import com.iafenvoy.sow.entity.power.AggroDetonateEntity;
import com.iafenvoy.sow.entity.power.AggroShardEntity;
import com.iafenvoy.sow.entity.power.AggroSphereEntity;
import com.iafenvoy.sow.particle.LaserParticleBuilder;
import com.iafenvoy.sow.registry.SowDamageTypes;
import com.iafenvoy.sow.registry.SowEntities;
import com.iafenvoy.sow.registry.SowParticles;
import com.iafenvoy.sow.registry.SowSounds;
import com.iafenvoy.sow.registry.power.SowAbilityCategories;
import com.iafenvoy.sow.util.SowMath;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class AggressiumPowers {
    public static final DeferredRegister<Ability<?>> REGISTRY = DeferredRegister.create((Registry)NeptuneRegistries.ABILITY, (String)"sow");
    public static final DeferredHolder<Ability<?>, PersistAbility> AGGROBEAM = REGISTRY.register("aggrobeam", () -> ((PersistAbility)((PersistAbility)((PersistAbility)new PersistAbility(SowAbilityCategories.AGGRESSIUM).experimental()).setApplySound(SowSounds.AGGROBEAM)).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.aggressium.aggrobeamExhaustion.getValue())).onTick(holder -> {
        LivingEntity living = holder.getEntity();
        Level world = holder.getWorld();
        double maxDistance = (Double)SowCommonConfig.INSTANCE.aggressium.aggrobeamMaxDistance.getValue();
        Vec3 rotation = SowMath.getRotationVectorUnit(living.getXRot(), living.getYHeadRot());
        Vec3 pos = living.position().add(0.0, 1.0, 0.0);
        Vec3 end = pos.add(rotation.scale(maxDistance));
        BlockHitResult result = world.clip(new ClipContext(pos, end, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)living));
        double d = result.getLocation().subtract(pos).length();
        Level patt0$temp = holder.getWorld();
        if (patt0$temp instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)patt0$temp;
            double OFFSET = 1.0;
            Vec3 p = pos.add(rotation.scale(1.0));
            serverWorld.sendParticles((ParticleOptions)new LaserParticleBuilder(living.getUUID(), 0.0, 0.0, result.getType() == HitResult.Type.BLOCK ? d : maxDistance, 1.0, 0.1f), p.x(), p.y(), p.z(), 0, 1.0, 0.0, 0.0, 1.0);
        }
        List results = RaycastHelper.raycastAll((Entity)living, (Vec3)pos, (Vec3)end, (AABB)new AABB(pos, end), entity -> entity instanceof LivingEntity, (double)(d * d));
        DamageSource source = DamageUtil.build((Entity)living, SowDamageTypes.AGGROBEAM);
        for (EntityHitResult r : results) {
            r.getEntity().hurt(source, holder.processDamage(((Double)SowCommonConfig.INSTANCE.aggressium.aggrobeamDamage.getValue()).floatValue()));
        }
    }));
    public static final DeferredHolder<Ability<?>, DelayAbility> AGGROBLAST = REGISTRY.register("aggroblast", () -> (DelayAbility)((DelayAbility)((DelayAbility)((DelayAbility)((DelayAbility)new DelayAbility(SowAbilityCategories.AGGRESSIUM).setApplySound(SowSounds.AGGROBLAST)).setDelay(8).setPrimaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.aggressium.aggroblastPrimaryCooldown.getValue())).setSecondaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.aggressium.aggroblastSecondaryCooldown.getValue())).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.aggressium.aggroblastExhaustion.getValue())).onApply(holder -> {
        Entity patt0$temp;
        double maxDistance;
        LivingEntity living = holder.getEntity();
        EntityHitResult result = RaycastHelper.raycastNearest((LivingEntity)living, (double)(maxDistance = ((Double)SowCommonConfig.INSTANCE.aggressium.aggroblastRange.getValue()).doubleValue()));
        if (result != null && (patt0$temp = result.getEntity()) instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)patt0$temp;
            double speed = (Double)SowCommonConfig.INSTANCE.aggressium.aggroblastSpeed.getValue();
            Vec3 dir = l.position().subtract(living.position()).scale(speed);
            l.setDeltaMovement(dir.add(0.0, 0.3, 0.0));
            l.hurtMarked = true;
            Level patt1$temp = holder.getWorld();
            if (patt1$temp instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)patt1$temp;
                Vec3 d = SowMath.getRotationVector(living.getXRot(), living.getYHeadRot());
                for (int i = 0; i < 30; ++i) {
                    serverWorld.sendParticles((ParticleOptions)((SimpleParticleType)SowParticles.AGGROBLAST.get()), living.getX(), living.getY() + 1.0, living.getZ(), 0, d.x, d.y, d.z, speed);
                }
            }
            l.hurt(DamageUtil.build((Entity)living, SowDamageTypes.AGGROBLAST), holder.processDamage(((Double)SowCommonConfig.INSTANCE.aggressium.aggroblastDamage.getValue()).floatValue()));
        } else {
            holder.cancel();
        }
    }));
    public static final DeferredHolder<Ability<?>, DelayAbility> AGGRODETONATE = REGISTRY.register("aggrodetonate", () -> (DelayAbility)((DelayAbility)((DelayAbility)((DelayAbility)((DelayAbility)new DelayAbility(SowAbilityCategories.AGGRESSIUM).setApplySound(SowSounds.AGGRODETONATE)).setDelay(12).setPrimaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.aggressium.aggrodetonatePrimaryCooldown.getValue())).setSecondaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.aggressium.aggrodetonateSecondaryCooldown.getValue())).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.aggressium.aggrodetonateExhaustion.getValue())).onApply(holder -> {
        Level world = holder.getWorld();
        LivingEntity living = holder.getEntity();
        AggroDetonateEntity aggroDetonate = (AggroDetonateEntity)((EntityType)SowEntities.AGGRO_DETONATE.get()).create(world);
        if (aggroDetonate != null) {
            Vec3 dir = SowMath.getRotationVectorUnit(living.getXRot(), living.getYHeadRot());
            aggroDetonate.setDeltaMovement(dir.scale(((Double)SowCommonConfig.INSTANCE.aggressium.aggrodetonateSpeed.getValue()).doubleValue()));
            holder.processProjectile((AbstractArrow)aggroDetonate);
            world.addFreshEntity((Entity)aggroDetonate);
        }
    }));
    public static final DeferredHolder<Ability<?>, DelayAbility> AGGROQUAKE = REGISTRY.register("aggroquake", () -> (DelayAbility)((DelayAbility)((DelayAbility)((DelayAbility)((DelayAbility)new DelayAbility(SowAbilityCategories.AGGRESSIUM).setApplySound(SowSounds.AGGROQUAKE)).setDelay(8).setPrimaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.aggressium.aggroquakePrimaryCooldown.getValue())).setSecondaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.aggressium.aggroquakeSecondaryCooldown.getValue())).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.aggressium.aggroquakeExhaustion.getValue())).onApply(holder -> {
        LivingEntity living = holder.getEntity();
        double r = (Double)SowCommonConfig.INSTANCE.aggressium.aggroquakeRange.getValue();
        Vec3 range = new Vec3(r, r, r);
        List entities = holder.getWorld().getEntitiesOfClass(LivingEntity.class, new AABB(living.position().add(range), living.position().subtract(range)), x -> x != living);
        for (LivingEntity l : entities) {
            Vec3 dir = SowMath.reverse(living.position().subtract(l.position()), r).scale(-0.5);
            l.hurt(DamageUtil.build((Entity)l, SowDamageTypes.AGGROQUAKE), holder.processDamage(((Double)SowCommonConfig.INSTANCE.aggressium.aggroquakeDamage.getValue()).floatValue()));
            l.setDeltaMovement(dir.add(0.0, 0.5, 0.0));
            l.hurtMarked = true;
        }
    }));
    public static final DeferredHolder<Ability<?>, DelayAbility> AGGROSHARD = REGISTRY.register("aggroshard", () -> (DelayAbility)((DelayAbility)((DelayAbility)((DelayAbility)((DelayAbility)new DelayAbility(SowAbilityCategories.AGGRESSIUM).setApplySound(SowSounds.AGGROSHARD)).setDelay(12).setPrimaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.aggressium.aggroshardPrimaryCooldown.getValue())).setSecondaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.aggressium.aggroshardSecondaryCooldown.getValue())).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.aggressium.aggroshardExhaustion.getValue())).onApply(holder -> {
        Level world = holder.getWorld();
        LivingEntity living = holder.getEntity();
        Random random = new Random();
        for (int i = 0; i < (Integer)SowCommonConfig.INSTANCE.aggressium.aggroshardCount.getValue(); ++i) {
            Timeout.create((int)random.nextInt(25), () -> {
                AggroShardEntity aggroShard = (AggroShardEntity)((EntityType)SowEntities.AGGRO_SHARD.get()).create(world);
                if (aggroShard != null) {
                    Vec3 dir = SowMath.getRotationVectorUnit(living.getXRot(), living.getYHeadRot());
                    double MUL = 0.2;
                    double speed = (Double)SowCommonConfig.INSTANCE.aggressium.aggroshardSpeed.getValue();
                    aggroShard.setDeltaMovement(dir.scale(speed).add(RandomHelper.nextDouble((double)(-speed * 0.2), (double)(speed * 0.2)), RandomHelper.nextDouble((double)(-speed * 0.2), (double)(speed * 0.2)), RandomHelper.nextDouble((double)(-speed * 0.2), (double)(speed * 0.2))));
                    holder.processProjectile((AbstractArrow)aggroShard);
                    world.addFreshEntity((Entity)aggroShard);
                }
            });
        }
    }));
    public static final DeferredHolder<Ability<?>, InstantAbility> AGGROSHOCK = REGISTRY.register("aggroshock", () -> (InstantAbility)((InstantAbility)((InstantAbility)((InstantAbility)((InstantAbility)new InstantAbility(SowAbilityCategories.AGGRESSIUM).experimental()).setPrimaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.aggressium.aggroshockPrimaryCooldown.getValue())).setSecondaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.aggressium.aggroshockSecondaryCooldown.getValue())).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.aggressium.aggroshockExhaustion.getValue())).onApply(holder -> {
        Level patt0$temp = holder.getWorld();
        if (!(patt0$temp instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)patt0$temp;
        LivingEntity living = holder.getEntity();
        Vec3 dir = SowMath.getRotationVectorUnit(living.getXRot(), living.getYHeadRot());
        Vec3 pos = living.position();
        for (int i = 0; i < (Integer)SowCommonConfig.INSTANCE.aggressium.aggroshockDistance.getValue(); ++i) {
            pos = pos.add(dir);
            EntityUtil.lightening((ServerLevel)serverWorld, (double)pos.x, (double)pos.y, (double)pos.z, (boolean)false);
        }
    }));
    public static final DeferredHolder<Ability<?>, DelayAbility> AGGROSPHERE = REGISTRY.register("aggrosphere", () -> (DelayAbility)((DelayAbility)((DelayAbility)((DelayAbility)((DelayAbility)new DelayAbility(SowAbilityCategories.AGGRESSIUM).setApplySound(SowSounds.AGGROSPHERE)).setDelay(36).setPrimaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.aggressium.aggrospherePrimaryCooldown.getValue())).setSecondaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.aggressium.aggrosphereSecondaryCooldown.getValue())).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.aggressium.aggrosphereExhaustion.getValue())).onApply(holder -> {
        Level world = holder.getWorld();
        LivingEntity living = holder.getEntity();
        AggroSphereEntity aggroSphere = (AggroSphereEntity)((EntityType)SowEntities.AGGRO_SPHERE.get()).create(world);
        if (aggroSphere != null) {
            Vec3 dir = SowMath.getRotationVectorUnit(living.getXRot(), living.getYHeadRot());
            aggroSphere.setDeltaMovement(dir.scale(((Double)SowCommonConfig.INSTANCE.aggressium.aggrosphereSpeed.getValue()).doubleValue()));
            holder.processProjectile((AbstractArrow)aggroSphere);
            world.addFreshEntity((Entity)aggroSphere);
        }
    }));
    public static final DeferredHolder<Ability<?>, PersistAbility> AGGROSTORM = REGISTRY.register("aggrostorm", () -> ((PersistAbility)((PersistAbility)((PersistAbility)new PersistAbility(SowAbilityCategories.AGGRESSIUM).experimental()).setApplySound(SowSounds.AGGROSTORM)).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.aggressium.aggrostormExhaustion.getValue())).onTick(holder -> {
        LivingEntity living = holder.getEntity();
        double r = (Double)SowCommonConfig.INSTANCE.aggressium.aggrostormRange.getValue();
        Vec3 range = new Vec3(r, r, r);
        List entities = holder.getWorld().getEntitiesOfClass(LivingEntity.class, new AABB(living.position().add(range), living.position().subtract(range)), x -> x != living);
        for (LivingEntity l : entities) {
            Vec3 v = living.position().subtract(l.position());
            Vec3 dir = SowMath.reverse(v, r).scale(((Double)SowCommonConfig.INSTANCE.aggressium.aggrostormStrength.getValue()).doubleValue());
            if (v.length() <= r / 2.0) {
                l.hurt(DamageUtil.build((Entity)l, SowDamageTypes.AGGROSTORM), holder.processDamage(((Double)SowCommonConfig.INSTANCE.aggressium.aggrostormDamage.getValue()).floatValue() / 20.0f));
            }
            l.setDeltaMovement(dir);
            l.hurtMarked = true;
        }
    }));
}

