/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.render.block;

import com.iafenvoy.sow.item.block.entity.WallsOfTimeBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WallsOfTimeBlockEntityRenderer
implements BlockEntityRenderer<WallsOfTimeBlockEntity> {
    private static final ResourceLocation FONT_ID = ResourceLocation.tryBuild((String)"minecraft", (String)"alt");
    private static final Style STYLE = Style.EMPTY.withFont(FONT_ID);
    private final Font textRenderer;

    public WallsOfTimeBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.textRenderer = ctx.getFont();
    }

    public void render(WallsOfTimeBlockEntity entity, float tickDelta, PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.pushPose();
        WallsOfTimeBlockEntity.WotContents contents = entity.getContents();
        matrices.translate(0.5, 0.5, 0.5);
        matrices.mulPose(Axis.YP.rotationDegrees((float)(180 - contents.getDirection().get2DDataValue() * 90)));
        matrices.translate(0.5, 0.5, (double)-0.501f);
        matrices.scale(-0.03125f, -0.03125f, 0.03125f);
        List texts = this.textRenderer.split((FormattedText)contents.getContentString().withStyle(STYLE), Math.max(0, contents.getSizeX()) * 32);
        for (int i = 0; i < texts.size() && i < contents.getSizeY() * 3; ++i) {
            this.textRenderer.drawInBatch((FormattedCharSequence)texts.get(i), (float)(2 + contents.getOffsetX() * 32), (float)(2 + (int)((double)i * 10.6) + contents.getOffsetY() * 32), 0x777777, false, matrices.last().pose(), vertexConsumers, Font.DisplayMode.NORMAL, 0, light);
        }
        matrices.popPose();
    }
}

