/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.render.entity;

import com.iafenvoy.sow.entity.ardoni.AbstractArdoniEntity;
import com.iafenvoy.sow.entity.util.Flatable;
import com.iafenvoy.sow.render.entity.feature.ardoni.ArdoniEyeFeatureRenderer;
import com.iafenvoy.sow.render.entity.feature.ardoni.ArdoniHairFeatureRenderer;
import com.iafenvoy.sow.render.entity.feature.ardoni.ArdoniMarkerFeatureRenderer;
import com.iafenvoy.sow.render.entity.feature.ardoni.ArdoniSkinFeatureRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ArdoniEntityRenderer
extends HumanoidMobRenderer<AbstractArdoniEntity, PlayerModel<AbstractArdoniEntity>> {
    public ArdoniEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (HumanoidModel)new PlayerModel(ctx.bakeLayer(ModelLayers.PLAYER), false), 0.5f);
        this.addLayer(new ArdoniSkinFeatureRenderer((RenderLayerParent<AbstractArdoniEntity, PlayerModel<AbstractArdoniEntity>>)this));
        this.addLayer(new ArdoniEyeFeatureRenderer((RenderLayerParent<AbstractArdoniEntity, PlayerModel<AbstractArdoniEntity>>)this));
        this.addLayer(new ArdoniHairFeatureRenderer((RenderLayerParent<AbstractArdoniEntity, PlayerModel<AbstractArdoniEntity>>)this));
        this.addLayer(new ArdoniMarkerFeatureRenderer((RenderLayerParent<AbstractArdoniEntity, PlayerModel<AbstractArdoniEntity>>)this));
    }

    public void render(@NotNull AbstractArdoniEntity entity, float f, float g, PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int i) {
        Flatable flatable;
        matrices.pushPose();
        matrices.scale(1.1f, 1.1f, 1.1f);
        if (entity instanceof Flatable && (flatable = (Flatable)((Object)entity)).isFlat()) {
            matrices.scale(1.0f, 0.001f, 1.0f);
        }
        super.render((LivingEntity)entity, f, g, matrices, vertexConsumers, i);
        matrices.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(AbstractArdoniEntity entity) {
        return entity.getTextureId();
    }
}

