/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.render.entity.feature.ardoni;

import com.iafenvoy.sow.config.SowClientConfig;
import com.iafenvoy.sow.entity.ardoni.AbstractArdoniEntity;
import com.iafenvoy.sow.entity.ardoni.random.ArdoniEntity;
import com.iafenvoy.sow.render.generator.ArdoniMarkerGenerator;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ArdoniMarkerFeatureRenderer
extends RenderLayer<AbstractArdoniEntity, PlayerModel<AbstractArdoniEntity>> {
    public ArdoniMarkerFeatureRenderer(RenderLayerParent<AbstractArdoniEntity, PlayerModel<AbstractArdoniEntity>> context) {
        super(context);
    }

    public void render(PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, AbstractArdoniEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        matrices.pushPose();
        SowClientConfig.processEmissiveStack(matrices);
        Optional marker = entity.getMarkerTextureId();
        PlayerModel model = new PlayerModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER), false);
        ((PlayerModel)this.getParentModel()).copyPropertiesTo((HumanoidModel)model);
        if (marker.isPresent()) {
            model.renderToBuffer(matrices, vertexConsumers.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)((ResourceLocation)marker.get()))), light, OverlayTexture.NO_OVERLAY, -1);
        } else if (entity instanceof ArdoniEntity) {
            ArdoniEntity ardoni = (ArdoniEntity)entity;
            ArdoniMarkerGenerator generator = ArdoniMarkerGenerator.getOrCreate(ardoni.getMarkerSeed());
            model.renderToBuffer(matrices, vertexConsumers.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)generator.getForSkin())), light, OverlayTexture.NO_OVERLAY, entity.getColor() | 0xFF000000);
        }
        matrices.popPose();
    }
}

