/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.render.entity.feature.ardoni;

import com.iafenvoy.neptune.util.RandomHelper;
import com.iafenvoy.sow.entity.ardoni.AbstractArdoniEntity;
import com.iafenvoy.sow.entity.ardoni.random.ArdoniEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArdoniSkinFeatureRenderer
extends RenderLayer<AbstractArdoniEntity, PlayerModel<AbstractArdoniEntity>> {
    private static final ResourceLocation ARDONI_SHADOW = ResourceLocation.fromNamespaceAndPath((String)"sow", (String)"textures/entity/ardoni/ardoni_shadow.png");

    public ArdoniSkinFeatureRenderer(RenderLayerParent<AbstractArdoniEntity, PlayerModel<AbstractArdoniEntity>> context) {
        super(context);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractArdoniEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        ArdoniEntity ardoni;
        int n;
        matrices.pushPose();
        matrices.scale(1.001f, 1.001f, 1.001f);
        if (entity instanceof ArdoniEntity) {
            ArdoniEntity ardoni2 = (ArdoniEntity)entity;
            n = ArdoniSkinFeatureRenderer.getDarkness(ardoni2.getArdoniType().dark(), ardoni2.getMarkerSeed());
        } else {
            n = 1;
        }
        int darkness = n;
        PlayerModel model = new PlayerModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER), false);
        ((PlayerModel)this.getParentModel()).copyPropertiesTo((HumanoidModel)model);
        model.renderToBuffer(matrices, vertexConsumers.getBuffer(model.renderType(entity.getTextureId())), light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f), 65793 * darkness + -16777216);
        if (entity instanceof ArdoniEntity && (ardoni = (ArdoniEntity)entity).getAge() >= 4) {
            model.renderToBuffer(matrices, vertexConsumers.getBuffer(RenderType.entityTranslucent((ResourceLocation)ARDONI_SHADOW)), light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f), 65793 * darkness + -16777216);
        }
        matrices.popPose();
    }

    public static int getDarkness(boolean dark, long seed) {
        return dark ? RandomHelper.nextInt((Random)new Random(seed), (int)115, (int)166) : RandomHelper.nextInt((Random)new Random(seed), (int)205, (int)255);
    }
}

