/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.render.generator;

import com.iafenvoy.sow.render.util.ImageRenderUtils;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArdoniMarkerGenerator {
    private static final Map<Long, ArdoniMarkerGenerator> GENERATORS = new HashMap<Long, ArdoniMarkerGenerator>();
    private final ArdoniLikeBooleanMapGenerator body;
    private final ArdoniLikeBooleanMapGenerator legs;
    private final Random random;
    private final ResourceLocation skinId;
    private final ResourceLocation graveId;
    private boolean present = false;

    private ArdoniMarkerGenerator(long seed) {
        this.random = new Random(seed);
        this.body = new ArdoniLikeBooleanMapGenerator(56, 12, this.random.nextLong());
        this.legs = new ArdoniLikeBooleanMapGenerator(32, 12, this.random.nextLong());
        this.skinId = ResourceLocation.tryBuild((String)"sow", (String)("ardoni_skin_marker_" + seed));
        this.graveId = ResourceLocation.tryBuild((String)"sow", (String)("ardoni_grave_marker_" + seed));
    }

    public static ArdoniMarkerGenerator getOrCreate(long seed) {
        if (!GENERATORS.containsKey(seed)) {
            GENERATORS.put(seed, new ArdoniMarkerGenerator(seed));
        }
        return GENERATORS.get(seed);
    }

    public static void resetAll() {
        GENERATORS.values().forEach(ArdoniMarkerGenerator::reset);
    }

    private static int generateColor(Random random) {
        int r = random.nextInt(192, 256);
        return 0xFF000000 | r << 16 | r << 8 | r;
    }

    public static void fill(Random random, NativeImage skin, NativeImage grave, int offsetX, int offsetY, boolean[][] map, ToIntFunction<Random> colorProvider) {
        for (int i = 0; i < map.length; ++i) {
            for (int j = 0; j < map[i].length; ++j) {
                int x = offsetX + i;
                int y = offsetY + j;
                int color = map[i][j] ? colorProvider.applyAsInt(random) : 0;
                skin.setPixelRGBA(x, y, color);
                grave.setPixelRGBA(x, y, 20 <= x && x <= 27 && 20 <= y && y <= 31 ? color : 0);
            }
        }
    }

    private void generate() {
        NativeImage skin = new NativeImage(64, 64, true);
        NativeImage grave = new NativeImage(64, 64, true);
        ArdoniMarkerGenerator.fill(this.random, skin, grave, 0, 20, this.body.generate(), ArdoniMarkerGenerator::generateColor);
        ArdoniMarkerGenerator.fill(this.random, skin, grave, 16, 52, this.legs.generate(), ArdoniMarkerGenerator::generateColor);
        ImageRenderUtils.upload(skin, this.skinId);
        ImageRenderUtils.upload(grave, this.graveId);
        this.present = true;
    }

    public ResourceLocation getForSkin() {
        if (!this.present) {
            this.generate();
        }
        return this.skinId;
    }

    public ResourceLocation getForGrave() {
        if (!this.present) {
            this.generate();
        }
        return this.graveId;
    }

    public void reset() {
        this.present = false;
    }

    public static class ArdoniLikeBooleanMapGenerator {
        private static final List<Integer> INDEX = List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7));
        private static final int[] DIR_X = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
        private static final int[] DIR_Y = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
        private final int width;
        private final int height;
        private final int flag;
        private final Random random;

        public ArdoniLikeBooleanMapGenerator(int width, int height, long seed) {
            this.width = width;
            this.height = height;
            this.flag = (int)Math.pow(width * height, 0.5);
            this.random = new Random(seed);
        }

        public boolean[][] generate() {
            boolean[][] data = new boolean[this.width][this.height];
            int count = this.random.nextInt(this.flag / 2, this.flag);
            LinkedList<PointHolder> queue = new LinkedList<PointHolder>();
            for (int i = 0; i < count; ++i) {
                int x = this.random.nextInt(this.width);
                int y = this.random.nextInt(this.height);
                int size = this.random.nextInt(this.flag, this.width * this.height);
                int dir = -1;
                queue.offer(new PointHolder(x, y, size, dir));
            }
            while (!queue.isEmpty()) {
                PointHolder o = (PointHolder)queue.poll();
                if (o.size <= 0 || !DirMapChecker.allow.check(this, data, o.x, o.y, o.dir)) continue;
                data[o.x][o.y] = true;
                for (Integer i : DirMapFinder.allowMap.check(this, data, o.x, o.y)) {
                    if (!this.random.nextBoolean()) continue;
                    queue.offer(new PointHolder(o.x + DIR_X[i], o.y + DIR_Y[i], this.random.nextInt((int)Math.floor((double)o.size * 2.0 / 3.0), o.size), (i + 4) % 8));
                }
            }
            return data;
        }

        public record PointHolder(int x, int y, int size, int dir) {
        }

        @FunctionalInterface
        public static interface DirMapChecker {
            public static final DirMapChecker allow = (gen, map, x, y, igDir) -> !map[x][y] && INDEX.stream().reduce(true, (p, c) -> p != false && (c == igDir || c == (igDir + 1) % 8 || c == (igDir + 7) % 8 || MapChecker.checkOrTrue.check(gen, x + DIR_X[c], y + DIR_Y[c], (_x, _y) -> !map[_x][_y])), (b1, b2) -> b1 != false && b2 != false) != false;

            public boolean check(ArdoniLikeBooleanMapGenerator var1, boolean[][] var2, int var3, int var4, int var5);
        }

        @FunctionalInterface
        public static interface DirMapFinder {
            public static final DirMapFinder allowMap = (gen, map, x, y) -> INDEX.stream().filter(v -> v % 2 == 0).filter(i -> MapChecker.checkOrFalse.check(gen, x + DIR_X[i], y + DIR_Y[i], (_x, _y) -> DirMapChecker.allow.check(gen, map, _x, _y, (i + 4) % 8))).toList();

            public List<Integer> check(ArdoniLikeBooleanMapGenerator var1, boolean[][] var2, int var3, int var4);
        }

        @FunctionalInterface
        public static interface MapChecker {
            public static final MapChecker checkOrTrue = (gen, x, y, fn) -> x < 0 || y < 0 || x >= gen.width || y >= gen.height || fn.call(x, y);
            public static final MapChecker checkOrFalse = (gen, x, y, fn) -> x >= 0 && y >= 0 && x < gen.width && y < gen.height && fn.call(x, y);

            public boolean check(ArdoniLikeBooleanMapGenerator var1, int var2, int var3, Callback var4);
        }

        @FunctionalInterface
        public static interface Callback {
            public boolean call(int var1, int var2);
        }
    }
}

