/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.render.generator;

import com.iafenvoy.neptune.util.PerlinNoise;
import com.iafenvoy.sow.render.util.ImageRenderUtils;
import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.floats.Float2IntFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class MagnoriteSkinGenerator {
    private static final ResourceLocation DEFAULT = ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/magnorite/magnorite_default.png");
    private static final ResourceLocation DEFAULT_MARKER = ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/magnorite/magnorite_default_marker.png");
    private static final Map<Long, MagnoriteSkinGenerator> GENERATORS = new HashMap<Long, MagnoriteSkinGenerator>();
    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(0, 3, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final long seed;
    private final ResourceLocation skinId;
    private final ResourceLocation markerId;
    private boolean present = false;
    private boolean executing = false;

    private MagnoriteSkinGenerator(long seed) {
        this.seed = seed;
        this.skinId = ResourceLocation.tryBuild((String)"sow", (String)("magnorite_skin_" + seed));
        this.markerId = ResourceLocation.tryBuild((String)"sow", (String)("magnorite_marker_" + seed));
    }

    public static MagnoriteSkinGenerator getOrCreate(long seed) {
        if (!GENERATORS.containsKey(seed)) {
            GENERATORS.put(seed, new MagnoriteSkinGenerator(seed));
        }
        return GENERATORS.get(seed);
    }

    public static void resetAll() {
        GENERATORS.values().forEach(MagnoriteSkinGenerator::reset);
    }

    public void reset() {
        this.present = false;
    }

    public ResourceLocation getForSkin() {
        if (!this.present) {
            this.generate();
            return DEFAULT;
        }
        return this.skinId;
    }

    public ResourceLocation getForMarker() {
        if (!this.present) {
            this.generate();
            return DEFAULT_MARKER;
        }
        return this.markerId;
    }

    private void generate() {
        if (!this.executing) {
            this.executing = true;
            EXECUTOR.execute(() -> {
                NativeImage skin = new NativeImage(64, 64, true);
                NativeImage marker = new NativeImage(64, 64, true);
                int[][] lavaMap = MagnoriteSkinGenerator.generateColors(this.seed, 0.2, List.of(PerlinNoise.NoiseConfig.of((double)8.0, (double)0.5), PerlinNoise.NoiseConfig.of((double)5.0, (double)0.25), PerlinNoise.NoiseConfig.of((double)3.0, (double)0.125), PerlinNoise.NoiseConfig.of((double)1.0, (double)0.0625)), h -> ImageRenderUtils.interpolateColor(-16759297, -16711681, h));
                ImageRenderUtils.fillWithCondition(skin, lavaMap, ImageRenderUtils::inFirstLayer);
                ImageRenderUtils.fillWithCondition(marker, lavaMap, ImageRenderUtils::inFirstLayer);
                int[][] carveColor = MagnoriteSkinGenerator.generateColors(this.seed + 1L, 0.0, List.of(PerlinNoise.NoiseConfig.of((double)1.0, (double)0.75), PerlinNoise.NoiseConfig.of((double)0.5, (double)0.5), PerlinNoise.NoiseConfig.of((double)0.25, (double)0.25)), h -> ImageRenderUtils.interpolateColor(-11378830, -15592164, h));
                int[][] carve = MagnoriteSkinGenerator.generateColors(this.seed + 2L, -0.5, List.of(PerlinNoise.NoiseConfig.of((double)2.0, (double)1.5), PerlinNoise.NoiseConfig.of((double)1.5, (double)1.5), PerlinNoise.NoiseConfig.of((double)0.5, (double)0.5)), h -> h > 0.0f ? -1 : 0);
                int[][] firstLayer = ImageRenderUtils.create(64, 64);
                int[][] secondLayer = ImageRenderUtils.create(64, 64);
                ImageRenderUtils.resolveCarve(carveColor, carve, firstLayer, secondLayer);
                ImageRenderUtils.fillWithCondition(skin, firstLayer, ImageRenderUtils::inFirstLayer);
                ImageRenderUtils.fillWithCondition(skin, secondLayer, ImageRenderUtils::inSecondLayer);
                ImageRenderUtils.fillWithCondition(skin, carveColor, ImageRenderUtils::isFirstFace);
                ImageRenderUtils.removeDuplicateWithCondition(marker, firstLayer, ImageRenderUtils::inFirstLayer);
                ImageRenderUtils.removeDuplicateWithCondition(marker, carveColor, ImageRenderUtils::isFirstFace);
                skin.setPixelRGBA(9, 11, -14735568);
                skin.setPixelRGBA(14, 11, -14735568);
                marker.setPixelRGBA(10, 11, -15100424);
                marker.setPixelRGBA(13, 11, -15100424);
                Minecraft.getInstance().execute(() -> {
                    ImageRenderUtils.upload(skin, this.skinId);
                    ImageRenderUtils.upload(marker, this.markerId);
                    this.present = true;
                    this.executing = false;
                });
            });
        }
    }

    public static double[][] generatePerlin(long seed, double base, List<PerlinNoise.NoiseConfig> config) {
        PerlinNoise noise = new PerlinNoise(seed, base, config);
        double[][] perlin = new double[64][64];
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                perlin[i][j] = noise.getHeight(i, j);
            }
        }
        return perlin;
    }

    public static int[][] generateColors(long seed, double base, List<PerlinNoise.NoiseConfig> config, Float2IntFunction colorLoader) {
        double[][] perlinMap = MagnoriteSkinGenerator.generatePerlin(seed, base, config);
        int[][] colorMap = ImageRenderUtils.create(64, 64);
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                colorMap[i][j] = (Integer)colorLoader.apply((Object)Float.valueOf((float)perlinMap[i][j]));
            }
        }
        ImageRenderUtils.smooth(colorMap, 0, 0, 64, 64);
        return colorMap;
    }
}

