/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.render.power.feature;

import com.iafenvoy.neptune.ability.AbilityData;
import com.iafenvoy.neptune.ability.type.Ability;
import com.iafenvoy.neptune.render.model.SphereModel;
import com.iafenvoy.sow.registry.power.ProtisiumPowers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ProteSphereFeatureRenderer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"sow", (String)"textures/sphere/protesphere.png");
    private final SphereModel<T> sphereModel = new SphereModel(SphereModel.getTexturedModelData().bakeRoot());

    public ProteSphereFeatureRenderer(RenderLayerParent<T, M> context) {
        super(context);
    }

    public void render(@NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, @NotNull T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (AbilityData.get(entity).abilityEnabled(new Ability[]{(Ability)ProtisiumPowers.PROTESPHERE.get()})) {
            matrices.pushPose();
            matrices.scale(2.5f, 2.5f, 2.5f);
            matrices.translate(0.0, -1.3, 0.0);
            VertexConsumer consumer = vertexConsumers.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)TEXTURE));
            this.sphereModel.renderToBuffer(matrices, consumer, light, OverlayTexture.NO_OVERLAY, 453017599);
            matrices.popPose();
        }
    }
}

