/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.screen;

import com.iafenvoy.sow.data.BeaconData;
import com.iafenvoy.sow.network.payload.BeaconTeleportC2SPayload;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BeaconTeleportScreen
extends Screen {
    private static final ResourceLocation ARROW = ResourceLocation.tryBuild((String)"minecraft", (String)"textures/gui/recipe_book.png");
    private static final int COUNT_PER_PAGE = 5;
    private final BeaconData beaconData;
    private final List<BeaconData.SingleBeaconData> data;
    private final BlockPos pos;
    private final int maxPage;
    private final int page;

    public BeaconTeleportScreen(BeaconData beaconData, BlockPos pos, int page) {
        super(beaconData.get(pos).map(BeaconData.SingleBeaconData::name).orElse((Component)Component.literal((String)"")));
        this.beaconData = beaconData;
        this.data = new ArrayList<BeaconData.SingleBeaconData>(beaconData.getBeaconPos());
        this.data.removeIf(x -> x.pos().equals((Object)pos));
        this.pos = pos;
        this.maxPage = (int)Math.ceil(1.0 * (double)this.data.size() / 5.0) - 1;
        this.page = page;
    }

    protected void init() {
        super.init();
        int middleX = this.width / 2;
        int middleY = this.height / 2;
        ((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$1(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((BeaconTeleportScreen)this)).bounds((int)(middleX - 44), (int)(middleY + 75), (int)14, (int)18).build())).visible = this.page > 0;
        ((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$2(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((BeaconTeleportScreen)this)).bounds((int)(middleX + 30), (int)(middleY + 75), (int)14, (int)18).build())).visible = this.page < this.maxPage;
        for (int i = 0; i < 5; ++i) {
            int index = this.page * 5 + i;
            if (this.data.size() <= index) break;
            BeaconData.SingleBeaconData d = this.data.get(index);
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)d.name(), button -> {
                PacketDistributor.sendToServer((CustomPacketPayload)new BeaconTeleportC2SPayload(this.pos, d.pos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.onClose();
            }).bounds(middleX - 50, middleY + (i - 2) * 25, 100, 20).build());
        }
    }

    public void tick() {
        super.tick();
        assert (this.minecraft != null && this.minecraft.player != null);
        if (this.minecraft.player.blockPosition().distSqr((Vec3i)this.pos) > 100.0) {
            this.onClose();
        }
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, this.title, this.width / 2, this.height / 2 - 85, -1);
        context.drawCenteredString(this.font, (Component)Component.literal((String)String.format("x=%d y=%d z=%d", this.pos.getX(), this.pos.getY(), this.pos.getZ())), this.width / 2, this.height / 2 - 70, -1);
        context.drawCenteredString(this.font, (Component)Component.literal((String)String.format("%d/%d", this.page + 1, this.maxPage + 1)), this.width / 2, this.height / 2 + 80, -1);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private /* synthetic */ void lambda$init$2(Button button) {
        assert (this.minecraft != null);
        this.minecraft.setScreen((Screen)new BeaconTeleportScreen(this.beaconData, this.pos, this.page + 1));
    }

    private /* synthetic */ void lambda$init$1(Button button) {
        assert (this.minecraft != null);
        this.minecraft.setScreen((Screen)new BeaconTeleportScreen(this.beaconData, this.pos, this.page - 1));
    }
}

