/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.compat.emi;

import com.iafenvoy.neptune.ability.type.Ability;
import com.iafenvoy.sow.item.SongCubeItem;
import com.iafenvoy.sow.registry.SowItems;
import com.iafenvoy.sow.registry.power.SupportiumPowers;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class SongRecipeHelper {
    private static final ResourceLocation SONG_RECIPE = ResourceLocation.tryBuild((String)"sow", (String)"song_recipe");
    private static final EmiTexture TEXTURE = new EmiTexture(ResourceLocation.tryBuild((String)"sow", (String)"textures/gui/gui_song_recipe.png"), 0, 0, 140, 44);
    private static final EmiStack WORKSTATION = EmiStack.of((ItemStack)SongCubeItem.getStack((Ability)SupportiumPowers.SUPPOROFORM.get()));
    private static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(SONG_RECIPE, (EmiRenderable)WORKSTATION, (EmiRenderable)TEXTURE);
    private static final List<SongRecipe> RECIPES = List.of(new SongRecipe("obsidian_helmet", new ItemStack((ItemLike)Items.OBSIDIAN, 5), new ItemStack((ItemLike)SowItems.ENDER_KNIGHT_HELMET.get())), new SongRecipe("obsidian_chestplate", new ItemStack((ItemLike)Items.OBSIDIAN, 8), new ItemStack((ItemLike)SowItems.ENDER_KNIGHT_CHESTPLATE.get())), new SongRecipe("obsidian_leggings", new ItemStack((ItemLike)Items.OBSIDIAN, 7), new ItemStack((ItemLike)SowItems.ENDER_KNIGHT_LEGGINGS.get())), new SongRecipe("obsidian_boots", new ItemStack((ItemLike)Items.OBSIDIAN, 4), new ItemStack((ItemLike)SowItems.ENDER_KNIGHT_BOOTS.get())));

    public static void register(EmiRegistry registry) {
        registry.addCategory(CATEGORY);
        registry.addWorkstation(CATEGORY, (EmiIngredient)WORKSTATION);
        for (SongRecipe recipe : RECIPES) {
            registry.addRecipe((EmiRecipe)recipe);
        }
    }

    private record SongRecipe(String id, ItemStack input, ItemStack output) implements EmiRecipe
    {
        public EmiRecipeCategory getCategory() {
            return CATEGORY;
        }

        public ResourceLocation getId() {
            return ResourceLocation.tryBuild((String)"sow", (String)"/song/%s".formatted(this.id));
        }

        public List<EmiIngredient> getInputs() {
            return List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{this.input})));
        }

        public List<EmiStack> getOutputs() {
            return List.of(EmiStack.of((ItemStack)this.output));
        }

        public int getDisplayWidth() {
            return 140;
        }

        public int getDisplayHeight() {
            return 44;
        }

        public void addWidgets(WidgetHolder widgets) {
            widgets.addTexture(TEXTURE, 0, 0);
            widgets.addSlot(this.getInputs().getFirst(), 13, 12);
            widgets.addSlot(EmiIngredient.of(List.of(WORKSTATION)), 61, 12);
            widgets.addSlot((EmiIngredient)this.getOutputs().getFirst(), 109, 12).recipeContext((EmiRecipe)this);
        }
    }
}

