/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.data;

import com.iafenvoy.sow.SongsOfWar;
import com.iafenvoy.sow.data.ArdoniNameProxy;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public enum ArdoniName implements ResourceManagerReloadListener,
ArdoniNameProxy
{
    INSTANCE;

    private static final List<String> NAMES;

    public void onResourceManagerReload(@NotNull ResourceManager manager) {
        NAMES.clear();
        ArdoniName.load(manager, Minecraft.getInstance().options.languageCode.toLowerCase(Locale.ROOT));
        if (NAMES.isEmpty()) {
            ArdoniName.load(manager, "en_us");
        }
        SongsOfWar.LOGGER.info("Successfully loaded {} ardoni name(s),", (Object)NAMES.size());
    }

    private static void load(ResourceManager manager, String language) {
        ResourceLocation file = ResourceLocation.fromNamespaceAndPath((String)"sow", (String)"ardoni_name/%s.txt".formatted(language));
        for (Resource resource : manager.getResourceStack(file)) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    String s;
                    while ((s = reader.readLine()) != null) {
                        NAMES.add(s);
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    @NotNull
    public String getNameBySeed(long seed) throws UnsupportedOperationException {
        return NAMES.get((int)(seed % (long)NAMES.size()));
    }

    static {
        NAMES = new ArrayList<String>();
    }
}

