/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.data;

import com.iafenvoy.neptune.util.Color4i;
import com.iafenvoy.neptune.util.RandomHelper;
import com.iafenvoy.sow.item.SowSpawnEggItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.neoforged.neoforge.registries.DeferredHolder;

public record ArdoniType(String id, boolean dark, Color4i primaryColor, List<Color4i> altColors) {
    private static final Map<String, ArdoniType> BY_ID = new HashMap<String, ArdoniType>();
    public static final ArdoniType NONE = new ArdoniType("none", false, new Color4i(255, 255, 255, 255), new Color4i[0]);
    public static final ArdoniType VOLTARIS = new ArdoniType("voltaris", true, new Color4i(255, 0, 0, 255), new Color4i[0]);
    public static final ArdoniType SENDARIS = new ArdoniType("sendaris", false, new Color4i(0, 0, 255, 255), new Color4i(0, 255, 255, 255));
    public static final ArdoniType NESTORIS = new ArdoniType("nestoris", false, new Color4i(255, 255, 0, 255), new Color4i(240, 155, 89, 255));
    public static final ArdoniType KALTARIS = new ArdoniType("kaltaris", false, new Color4i(0, 255, 0, 255), new Color4i[0]);
    public static final ArdoniType MENDORIS = new ArdoniType("mendoris", false, new Color4i(160, 32, 240, 255), new Color4i(234, 63, 247, 255));

    public ArdoniType(String id, boolean dark, Color4i primaryColor, Color4i ... altColors) {
        this(id, dark, primaryColor, List.of(altColors));
        BY_ID.put(id, this);
    }

    public Color4i getColor(long seed) {
        Random random = new Random(seed);
        if (this.altColors.isEmpty() || random.nextInt(3) > 0) {
            return this.primaryColor;
        }
        return (Color4i)RandomHelper.randomOne((Random)random, this.altColors);
    }

    public static ArdoniType byId(String id) {
        return BY_ID.getOrDefault(id, NONE);
    }

    public static ArdoniType random() {
        return (ArdoniType)RandomHelper.randomOne(new ArrayList<ArdoniType>(BY_ID.values()));
    }

    public SowSpawnEggItem createSpawnEgg(DeferredHolder<EntityType<?>, ? extends EntityType<? extends Mob>> type) {
        return new SowSpawnEggItem(type, -7829368, this.primaryColor.getIntValue());
    }

    public Component formatName(String prefix) {
        if (this == NONE || this.id.isEmpty()) {
            return Component.literal((String)prefix);
        }
        return Component.translatable((String)"ardoniType.sow.%s".formatted(this.id), (Object[])new Object[]{Component.literal((String)prefix)});
    }
}

