/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.data;

import com.iafenvoy.neptune.render.SkullRenderRegistry;
import com.iafenvoy.neptune.util.Color4i;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;

public class SkullManager {
    private static final Map<SkullBlock.Type, Tuple<ResourceLocation, Color4i>> MARKER_TEXTURES = new HashMap<SkullBlock.Type, Tuple<ResourceLocation, Color4i>>();

    public static void registerSkull(SkullBlock.Type type, ResourceLocation texture, Block ... blocks) {
        SkullRenderRegistry.register((SkullBlock.Type)type, (ResourceLocation)texture, (Block[])blocks);
    }

    public static void registerSkull(SkullBlock.Type type, ResourceLocation texture, ResourceLocation marker, Color4i color, Block ... blocks) {
        SkullRenderRegistry.register((SkullBlock.Type)type, (ResourceLocation)texture, (Block[])blocks);
        MARKER_TEXTURES.put(type, (Tuple<ResourceLocation, Color4i>)new Tuple((Object)marker, (Object)color));
    }

    public static Tuple<ResourceLocation, Color4i> getMarkerTexture(PlayerHeadItem skull) {
        Tuple<ResourceLocation, Color4i> tuple;
        Block block = skull.getBlock();
        if (block instanceof SkullBlock) {
            SkullBlock skullBlock = (SkullBlock)block;
            tuple = MARKER_TEXTURES.get(skullBlock.getType());
        } else {
            tuple = null;
        }
        return tuple;
    }
}

