/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.entity.ardoni;

import com.iafenvoy.neptune.util.Color4i;
import com.iafenvoy.sow.Proxies;
import com.iafenvoy.sow.config.Anniversary;
import com.iafenvoy.sow.data.ArdoniType;
import com.iafenvoy.sow.entity.ardoni.AbstractArdoniEntity;
import com.iafenvoy.sow.registry.SowDelight;
import com.iafenvoy.sow.registry.SowWeapons;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ThalleousEntity
extends AbstractArdoniEntity {
    public static final ResourceLocation TEXTURE = ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/ardoni/special/thalleous.png");
    public static final ResourceLocation TEXTURE_MARKER = ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/ardoni/special/thalleous_marker.png");
    public static final Color4i COLOR = new Color4i(0, 162, 232, 255);

    public ThalleousEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        ItemStack stack = new ItemStack((ItemLike)SowWeapons.SWORD_THALLEOUS.get());
        this.setItemInHand(InteractionHand.MAIN_HAND, Proxies.reforgedStoneProxy.apply(stack, "blue", true));
        if (Anniversary.shouldInvoke()) {
            this.setItemInHand(InteractionHand.OFF_HAND, SowDelight.PEAS_CAN.toStack());
        }
    }

    public ResourceLocation getTextureId() {
        return TEXTURE;
    }

    public Optional<ResourceLocation> getMarkerTextureId() {
        return Optional.ofNullable(TEXTURE_MARKER);
    }

    @Override
    public Color4i getColor() {
        return COLOR;
    }

    @Override
    public ArdoniType getArdoniType() {
        return ArdoniType.SENDARIS;
    }
}

