/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.entity.human;

import com.iafenvoy.sow.entity.felina.NiikaEntity;
import com.iafenvoy.sow.entity.human.AbstractHumanEntity;
import com.iafenvoy.sow.entity.necromancer.AbstractNecromancerEntity;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class LucanEntity
extends AbstractHumanEntity {
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(LucanEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final ResourceLocation TEXTURE = ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/human/lucan/lucan.png");

    public LucanEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    public int getState() {
        return (Integer)this.entityData.get(STATE);
    }

    public void setState(int state) {
        this.entityData.set(STATE, (Object)state);
    }

    public void tick() {
        super.tick();
        if (!this.getCommandSenderWorld().getEntitiesOfClass(AbstractNecromancerEntity.class, new AABB(this.position().add(20.0, 10.0, 20.0), this.position().subtract(20.0, 10.0, 20.0)), LivingEntity::isAlive).isEmpty()) {
            if (!this.getCommandSenderWorld().getEntitiesOfClass(NiikaEntity.class, new AABB(this.position().add(10.0, 5.0, 10.0), this.position().subtract(20.0, 5.0, 20.0)), LivingEntity::isAlive).isEmpty()) {
                this.setState(2);
            } else {
                this.setState(1);
            }
        } else {
            this.setState(0);
        }
    }

    public ResourceLocation getTextureId() {
        if (this.getState() == 0) {
            if (this.getHealth() <= this.getMaxHealth() / 2.0f) {
                return ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/human/lucan/lucan_bandaged.png");
            }
            return TEXTURE;
        }
        if (this.getState() == 1) {
            return ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/human/lucan/lucan_necro.png");
        }
        if (this.getState() == 2) {
            return ResourceLocation.tryBuild((String)"sow", (String)"textures/entity/human/lucan/lucan_necro_hoodless.png");
        }
        return TEXTURE;
    }
}

