/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.entity.human.guard;

import com.iafenvoy.neptune.util.RandomHelper;
import com.iafenvoy.sow.data.KingdomType;
import com.iafenvoy.sow.entity.human.AbstractHumanEntity;
import com.iafenvoy.sow.registry.SowWeapons;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGuardEntity
extends AbstractHumanEntity {
    protected static final List<Supplier<? extends Item>> GUARD_WEAPONS = List.of(() -> Items.IRON_SWORD, SowWeapons.SPEAR_HEAVY_IRON, SowWeapons.SPEAR_IRON, SowWeapons.SPEAR_IRON_1, SowWeapons.SPEAR_IRON_3, SowWeapons.SPEAR_IRON_4, SowWeapons.SPEAR_LIGHT_IRON);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(AbstractGuardEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    protected AbstractGuardEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)((Supplier)RandomHelper.randomOne(GUARD_WEAPONS)).get()));
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)1);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("variant", this.getVariant());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("variant")) {
            this.setVariant(nbt.getInt("variant"));
        } else {
            this.setVariant(RandomHelper.nextInt((int)1, (int)this.getVariantCount()));
        }
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        SpawnGroupData data = super.finalizeSpawn(world, difficulty, spawnReason, entityData);
        this.setVariant(RandomHelper.nextInt((int)1, (int)this.getVariantCount()));
        return data;
    }

    public abstract KingdomType getKingdom();

    public abstract int getVariantCount();

    public ResourceLocation getTextureId() {
        return ResourceLocation.tryBuild((String)"sow", (String)("textures/entity/human/guard/" + this.getKingdom().getId() + "/guard_" + this.getVariant() + ".png"));
    }
}

