/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.event;

import com.iafenvoy.sow.Proxies;
import com.iafenvoy.sow.config.SowClientConfig;
import com.iafenvoy.sow.registry.SowSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static SoundInstance DEATH_SOUND_INSTANCE = null;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Proxies.songCubeSoundManager.tick();
    }

    @SubscribeEvent
    public static void onDeathScreenOpen(ScreenEvent.Opening event) {
        LocalPlayer player;
        if (!((Boolean)SowClientConfig.INSTANCE.enableDeathSound.getValue()).booleanValue()) {
            return;
        }
        if (event.getCurrentScreen() instanceof DeathScreen && DEATH_SOUND_INSTANCE != null) {
            Minecraft.getInstance().getSoundManager().stop(DEATH_SOUND_INSTANCE);
            DEATH_SOUND_INSTANCE = null;
        }
        if (event.getNewScreen() instanceof DeathScreen && (player = Minecraft.getInstance().player) != null) {
            DEATH_SOUND_INSTANCE = new SimpleSoundInstance((SoundEvent)SowSounds.SOW_DEATH.get(), SoundSource.PLAYERS, 1.0f, 0.0f, RandomSource.create((long)0L), player.getX(), player.getY(), player.getZ());
            Minecraft.getInstance().getSoundManager().play(DEATH_SOUND_INSTANCE);
        }
    }
}

