/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.neptune.ability.AbilityData;
import com.iafenvoy.sow.config.SowCommonConfig;
import com.iafenvoy.sow.registry.SowDataComponents;
import com.iafenvoy.sow.registry.power.SowAbilityCategories;
import com.iafenvoy.sow.world.song.SongChunkManager;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class AdjustedSongStoneItem
extends Item {
    public static final String NEAR_KEY = "near_song";
    private final DeferredHolder<AbilityCategory, AbilityCategory> category;

    public AdjustedSongStoneItem(DeferredHolder<AbilityCategory, AbilityCategory> category) {
        super(new Item.Properties().rarity(Rarity.RARE).stacksTo(1));
        this.category = category;
    }

    @NotNull
    public String getDescriptionId() {
        return "item.sow.adjusted_song_stone";
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)((AbilityCategory)this.category.get()).appendColor(Component.translatable((String)String.format("block.%s_song", this.category.getId().toLanguageKey()))));
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (world instanceof ServerLevel) {
            Player player;
            ServerLevel serverWorld = (ServerLevel)world;
            if (!(entity instanceof Player) || !AbilityData.get((LivingEntity)(player = (Player)entity)).isEnabled((AbilityCategory[])SowAbilityCategories.ALL.get().toArray(AbilityCategory[]::new))) {
                stack.remove(SowDataComponents.SONG_STONE_NEAR);
            } else {
                ChunkPos pos = entity.chunkPosition();
                if (SongChunkManager.isSongChunk((WorldGenLevel)serverWorld, (AbilityCategory)this.category.get(), pos)) {
                    stack.set(SowDataComponents.SONG_STONE_NEAR, (Object)Float.valueOf(1.0f));
                } else if (SongChunkManager.hasSongChunk((WorldGenLevel)serverWorld, (AbilityCategory)this.category.get(), pos, (Integer)SowCommonConfig.INSTANCE.common.songChunkDetectRange.getValue())) {
                    stack.set(SowDataComponents.SONG_STONE_NEAR, (Object)Float.valueOf(0.5f));
                } else {
                    stack.remove(SowDataComponents.SONG_STONE_NEAR);
                }
            }
        }
    }
}

