/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item;

import com.iafenvoy.neptune.render.SkullRenderRegistry;
import com.iafenvoy.neptune.util.Color4i;
import com.iafenvoy.sow.data.ArdoniType;
import com.iafenvoy.sow.item.block.ArdoniGraveBlock;
import com.iafenvoy.sow.registry.SowBlocks;
import com.iafenvoy.sow.render.generator.ArdoniMarkerGenerator;
import java.util.Optional;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ArdoniGraveItem
extends BlockItem
implements SkullRenderRegistry.SkullTextureProvider {
    public ArdoniGraveItem(ArdoniGraveBlock block) {
        super((Block)block, new Item.Properties());
    }

    public static ItemStack buildGrave(long seed, ArdoniType type, int age, boolean female) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("fixed", false);
        nbt.putLong("seed", seed);
        nbt.putString("type", type.id());
        nbt.putInt("age", age);
        nbt.putBoolean("female", female);
        ItemStack stack = new ItemStack((ItemLike)SowBlocks.ARDONI_GRAVE.get());
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbt));
        return stack;
    }

    public static ItemStack buildGrave(ResourceLocation texture, Color4i color) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("fixed", true);
        nbt.putString("texturePath", texture.toString());
        nbt.putInt("color", color.getIntValue());
        ItemStack stack = new ItemStack((ItemLike)SowBlocks.ARDONI_GRAVE.get());
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbt));
        return stack;
    }

    public Optional<SkullRenderRegistry.SkinInfo> getTexture(ItemStack stack) {
        ArdoniData data = ArdoniGraveItem.resolveData(stack);
        return Optional.of(new SkullRenderRegistry.SkinInfo(ResourceLocation.fromNamespaceAndPath((String)"sow", (String)"textures/entity/ardoni/ardoni_base%s.png".formatted(data != null && data.dark() ? "_dark" : "")), PlayerSkin.Model.WIDE));
    }

    @Nullable
    public static ArdoniData resolveData(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data == null) {
            return null;
        }
        CompoundTag nbt = data.copyTag();
        if (!nbt.contains("fixed", 1)) {
            return null;
        }
        boolean fixed = nbt.getBoolean("fixed");
        if (fixed) {
            return new ArdoniData(nbt.getString("texturePath"), nbt.getInt("color"));
        }
        return new ArdoniData(nbt.getLong("seed"), ArdoniType.byId(nbt.getString("type")), nbt.getInt("age"), nbt.getBoolean("female"));
    }

    public record ArdoniData(boolean fixed, long seed, ResourceLocation marker, Color4i color, int age, boolean female, boolean dark) {
        public ArdoniData(String texture, int color) {
            this(ResourceLocation.tryParse((String)texture), new Color4i(color));
        }

        public ArdoniData(ResourceLocation texture, Color4i color) {
            this(true, 0L, texture, color, 0, false, false);
        }

        public ArdoniData(long seed, ArdoniType type, int age, boolean female) {
            this(false, seed, ArdoniMarkerGenerator.getOrCreate(seed).getForSkin(), type.getColor(seed), age, female, type.dark());
        }
    }
}

