/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.neptune.ability.AbilityData;
import com.iafenvoy.neptune.registry.NeptuneDataComponents;
import com.iafenvoy.sow.registry.power.SowAbilityCategories;
import com.iafenvoy.sow.world.song.SongChunkManager;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import org.jetbrains.annotations.NotNull;

public class SongStoneItem
extends Item {
    public static final String POWER_KEY = "song_power";

    public SongStoneItem() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON).stacksTo(1));
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (world instanceof ServerLevel) {
            Player player;
            ServerLevel serverWorld = (ServerLevel)world;
            if (entity instanceof Player && AbilityData.get((LivingEntity)(player = (Player)entity)).isEnabled((AbilityCategory[])SowAbilityCategories.ALL.get().toArray(AbilityCategory[]::new))) {
                AbilityCategory category = SongChunkManager.find((WorldGenLevel)serverWorld, entity.chunkPosition());
                if (category != null) {
                    stack.set((Supplier)NeptuneDataComponents.ABILITY_CATEGORY, (Object)category);
                } else {
                    stack.remove((Supplier)NeptuneDataComponents.ABILITY_CATEGORY);
                }
            } else {
                stack.remove((Supplier)NeptuneDataComponents.ABILITY_CATEGORY);
            }
        }
    }
}

