/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item;

import com.iafenvoy.sow.item.block.entity.WallsOfTimeBlockEntity;
import com.iafenvoy.sow.registry.SowDataComponents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class WallsOfTimeEditItem
extends Item {
    public WallsOfTimeEditItem() {
        super(new Item.Properties().rarity(Rarity.EPIC).stacksTo(1).component(SowDataComponents.WOT_EDIT_TYPE, (Object)WallsOfTimeBlockEntity.EditType.OFFSET_X_PLUS));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player user, @NotNull InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        WallsOfTimeBlockEntity.EditType type = (WallsOfTimeBlockEntity.EditType)((Object)stack.get(SowDataComponents.WOT_EDIT_TYPE));
        if (user.isShiftKeyDown() && type != null) {
            WallsOfTimeBlockEntity.EditType next = type.next();
            stack.set(SowDataComponents.WOT_EDIT_TYPE, (Object)next);
            user.displayClientMessage((Component)Component.translatable((String)"item.sow.walls_of_time_edit.mode", (Object[])new Object[]{next.name()}), true);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(world, user, hand);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"item.sow.walls_of_time_edit.mode", (Object[])new Object[]{((WallsOfTimeBlockEntity.EditType)((Object)stack.getOrDefault((DataComponentType)SowDataComponents.WOT_EDIT_TYPE.get(), (Object)WallsOfTimeBlockEntity.EditType.OFFSET_X_PLUS))).name()}));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = world.getBlockState(pos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof WallsOfTimeBlockEntity) {
            WallsOfTimeBlockEntity blockEntity2 = (WallsOfTimeBlockEntity)blockEntity;
            WallsOfTimeBlockEntity.EditType type = (WallsOfTimeBlockEntity.EditType)((Object)context.getItemInHand().get(SowDataComponents.WOT_EDIT_TYPE));
            if (type != null) {
                type.getProcess().accept(blockEntity2.getContents());
                world.sendBlockUpdated(pos, state, state, 0);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }
}

