/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item.block;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFoodPlateBlock<T extends Enum<T>>
extends HorizontalDirectionalBlock {
    protected static final IntegerProperty ITEM_COUNT = IntegerProperty.create((String)"item_count", (int)0, (int)5);

    public AbstractFoodPlateBlock(Function<BlockBehaviour.Properties, BlockBehaviour.Properties> settings) {
        super(settings.apply(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JUNGLE_WOOD)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ITEM_COUNT, (Comparable)Integer.valueOf(0))).setValue(this.getFoodTypeProperty(), this.getDefaultFoodType()));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, ITEM_COUNT, this.getFoodTypeProperty()});
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        ItemStack inHand = player.getItemInHand(hand);
        int i = (Integer)state.getValue((Property)ITEM_COUNT);
        EnumProperty<T> foodType = this.getFoodTypeProperty();
        T defaultType = this.getDefaultFoodType();
        FoodType type = (FoodType)((Object)state.getValue(foodType));
        if (inHand.isEmpty()) {
            if (type == defaultType || i == 0) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            player.setItemInHand(hand, new ItemStack((ItemLike)type.getItem()));
            if (i > 1) {
                level.setBlock(pos, (BlockState)state.setValue((Property)ITEM_COUNT, (Comparable)Integer.valueOf(i - 1)), 3);
            } else {
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)ITEM_COUNT, (Comparable)Integer.valueOf(0))).setValue(foodType, defaultType), 3);
            }
            return ItemInteractionResult.SUCCESS;
        }
        T target = this.getFoodTypeFromItem(inHand.getItem());
        if (target != defaultType && (type == defaultType || type == target) && i < ((FoodType)target).getMaxPlacement()) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)ITEM_COUNT, (Comparable)Integer.valueOf(i + 1))).setValue(foodType, target), 3);
            inHand.shrink(1);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public void playerDestroy(@NotNull Level world, @NotNull Player player, @NotNull BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack tool) {
        AbstractFoodPlateBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)((FoodType)((Object)((Enum)((Object)state.getValue(this.getFoodTypeProperty()))))).getItem(), ((Integer)state.getValue((Property)ITEM_COUNT)).intValue()));
        super.playerDestroy(world, player, pos, state, blockEntity, tool);
    }

    protected abstract EnumProperty<T> getFoodTypeProperty();

    protected abstract T getDefaultFoodType();

    protected abstract T getFoodTypeFromItem(Item var1);

    protected static interface FoodType
    extends StringRepresentable {
        public Item getItem();

        public int getMaxPlacement();
    }
}

