/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item.block;

import com.iafenvoy.sow.item.block.entity.ArdoniGraveBlockEntity;
import com.iafenvoy.sow.registry.SowTags;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArdoniGraveBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final MapCodec<ArdoniGraveBlock> CODEC = ArdoniGraveBlock.simpleCodec(x -> new ArdoniGraveBlock());
    public static final BooleanProperty ACTIVATED = BooleanProperty.create((String)"activated");

    public ArdoniGraveBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).lightLevel(state -> (Boolean)state.getValue((Property)ACTIVATED) != false ? 15 : 0).emissiveRendering((state, world, pos) -> (Boolean)state.getValue((Property)ACTIVATED)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, ACTIVATED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ArdoniGraveBlockEntity(pos, state);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (player.getItemInHand(hand).is(SowTags.MASTER_STAFF)) {
            boolean activated = (Boolean)state.getValue((Property)ACTIVATED);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(!activated)));
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> Shapes.box((double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.75, (double)0.875);
            case Direction.SOUTH -> Shapes.box((double)0.25, (double)0.0, (double)0.125, (double)0.75, (double)0.75, (double)0.25);
            case Direction.WEST -> Shapes.box((double)0.75, (double)0.0, (double)0.25, (double)0.875, (double)0.75, (double)0.75);
            case Direction.EAST -> Shapes.box((double)0.125, (double)0.0, (double)0.25, (double)0.25, (double)0.75, (double)0.75);
            case Direction.DOWN, Direction.UP -> Shapes.empty();
        };
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

