/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item.block;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class FoodBlockWithPiece
extends Block {
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)3);
    private final int maxBite;
    private final FoodProperties food;

    public FoodBlockWithPiece(Function<BlockBehaviour.Properties, BlockBehaviour.Properties> settings, int maxBite, FoodProperties food) {
        super(settings.apply(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE)));
        this.maxBite = maxBite;
        this.food = food;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BITES});
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull BlockHitResult hitResult) {
        if (!player.canEat(this.food.canAlwaysEat())) {
            return InteractionResult.PASS;
        }
        player.getFoodData().eat(this.food.nutrition(), this.food.saturation());
        for (FoodProperties.PossibleEffect pair : this.food.effects()) {
            if (!(player.getRandom().nextDouble() < (double)pair.probability())) continue;
            player.addEffect(pair.effect());
        }
        int i = (Integer)state.getValue((Property)BITES);
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        if (i < this.maxBite) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            level.removeBlock(pos, false);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (!ModList.get().isLoaded("farmersdelight")) {
            tooltipComponents.add((Component)Component.translatable((String)"item.sow.tooltip.require.delight"));
        }
    }
}

