/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item.block;

import com.iafenvoy.sow.item.block.entity.TemporaryTransparentBlockEntity;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemporaryTransparentBlock
extends TransparentBlock
implements EntityBlock {
    public TemporaryTransparentBlock(Function<BlockBehaviour.Properties, BlockBehaviour.Properties> settings) {
        super(settings.apply(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TemporaryTransparentBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level world, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> TemporaryTransparentBlockEntity.tick(world1, pos, state1, (TemporaryTransparentBlockEntity)blockEntity);
    }

    public static void place(Level world, BlockPos pos, BlockState state, int tick) {
        BlockState s = world.getBlockState(pos);
        world.setBlockAndUpdate(pos, state);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TemporaryTransparentBlockEntity) {
            TemporaryTransparentBlockEntity blockEntity2 = (TemporaryTransparentBlockEntity)blockEntity;
            blockEntity2.setTick(tick);
            blockEntity2.setState(s);
        }
    }

    public void fallOn(@NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, float fallDistance) {
        if (this.getJumpFactor() <= 2.0f) {
            super.fallOn(world, state, pos, entity, fallDistance);
        }
    }
}

