/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item.block.entity;

import com.iafenvoy.sow.data.ArdoniType;
import com.iafenvoy.sow.item.block.ArdoniGraveBlock;
import com.iafenvoy.sow.registry.SowBlockEntities;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ArdoniGraveBlockEntity
extends BlockEntity {
    private long seed;
    private boolean fixed;
    private ResourceLocation texturePath = ResourceLocation.tryParse((String)"");
    private ArdoniType ardoniType = ArdoniType.NONE;

    public ArdoniGraveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SowBlockEntities.ARDONI_GRAVE.get(), pos, state);
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.setSeed(nbt.getLong("seed"));
        this.setFixed(nbt.getBoolean("fixed"));
        this.setArdoniType(ArdoniType.byId(nbt.getString("type")));
        this.setTexturePath(ResourceLocation.tryParse((String)nbt.getString("texturePath").toLowerCase(Locale.ROOT)));
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putLong("seed", this.getSeed());
        nbt.putBoolean("fixed", this.isFixed());
        nbt.putString("type", this.getArdoniType().id());
        nbt.putString("texturePath", this.getTexturePath().toString());
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setArdoniType(ArdoniType ardoniType) {
        this.ardoniType = ardoniType;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setTexturePath(ResourceLocation texturePath) {
        this.texturePath = texturePath;
    }

    public ArdoniType getArdoniType() {
        return this.ardoniType;
    }

    public ResourceLocation getTexturePath() {
        return this.texturePath;
    }

    public boolean activated() {
        return (Boolean)this.getBlockState().getValue((Property)ArdoniGraveBlock.ACTIVATED);
    }

    public float getRotationDegree() {
        return -((Direction)this.getBlockState().getValue((Property)ArdoniGraveBlock.FACING)).toYRot() + 180.0f;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

